/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.iterators.IteratorIterable;

public class IteratorIterableTest
extends BulkTest {
    public static Test suite() {
        return BulkTest.makeSuite(IteratorIterableTest.class);
    }

    public IteratorIterableTest(String name) {
        super(name);
    }

    private Iterator<Integer> createIterator() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        list.add(2);
        Iterator<Integer> iter = list.iterator();
        return iter;
    }

    public void testIterator() {
        Iterator<Integer> iter = this.createIterator();
        IteratorIterable iterable = new IteratorIterable(iter);
        this.verifyIteration((Iterable<Number>)iterable);
        for (Number actual : iterable) {
            IteratorIterableTest.fail((String)"should not be able to iterate twice");
        }
    }

    public void testMultipleUserIterator() {
        Iterator<Integer> iter = this.createIterator();
        IteratorIterable iterable = new IteratorIterable(iter, true);
        this.verifyIteration((Iterable<Number>)iterable);
        this.verifyIteration((Iterable<Number>)iterable);
    }

    private void verifyIteration(Iterable<Number> iterable) {
        int expected = 0;
        for (Number actual : iterable) {
            IteratorIterableTest.assertEquals((int)expected, (int)actual.intValue());
            ++expected;
        }
        IteratorIterableTest.assertTrue((expected > 0 ? 1 : 0) != 0);
    }
}

