/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class CaseInsensitiveMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public CaseInsensitiveMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(CaseInsensitiveMapTest.class);
    }

    @Override
    public CaseInsensitiveMap<K, V> makeObject() {
        return new CaseInsensitiveMap();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testCaseInsensitive() {
        CaseInsensitiveMap<String, String> map = this.makeObject();
        map.put("One", "One");
        map.put("Two", "Two");
        CaseInsensitiveMapTest.assertEquals((Object)"One", map.get("one"));
        CaseInsensitiveMapTest.assertEquals((Object)"One", map.get("oNe"));
        map.put("two", "Three");
        CaseInsensitiveMapTest.assertEquals((Object)"Three", map.get("Two"));
    }

    public void testNullHandling() {
        CaseInsensitiveMap<String, String> map = this.makeObject();
        map.put("One", "One");
        map.put("Two", "Two");
        map.put(null, "Three");
        CaseInsensitiveMapTest.assertEquals((Object)"Three", map.get(null));
        map.put(null, "Four");
        CaseInsensitiveMapTest.assertEquals((Object)"Four", map.get(null));
        Set keys = map.keySet();
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("one"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("two"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains(null));
        CaseInsensitiveMapTest.assertEquals((int)3, (int)keys.size());
    }

    public void testPutAll() {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put("One", "One");
        map.put("Two", "Two");
        map.put("one", "Three");
        map.put(null, "Four");
        map.put(20, "Five");
        CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(map);
        CaseInsensitiveMapTest.assertEquals((int)4, (int)caseInsensitiveMap.size());
        Set keys = caseInsensitiveMap.keySet();
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("one"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains("two"));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains(null));
        CaseInsensitiveMapTest.assertTrue((boolean)keys.contains(Integer.toString(20)));
        CaseInsensitiveMapTest.assertEquals((int)4, (int)keys.size());
        CaseInsensitiveMapTest.assertTrue((!caseInsensitiveMap.containsValue("One") || !caseInsensitiveMap.containsValue("Three") ? 1 : 0) != 0);
        CaseInsensitiveMapTest.assertEquals((String)"Four", (String)((String)caseInsensitiveMap.get(null)));
    }

    public void testClone() {
        CaseInsensitiveMap map = new CaseInsensitiveMap(10);
        map.put((Object)"1", (Object)"1");
        CaseInsensitiveMap cloned = map.clone();
        CaseInsensitiveMapTest.assertEquals((int)map.size(), (int)cloned.size());
        CaseInsensitiveMapTest.assertSame((Object)map.get((Object)"1"), (Object)cloned.get((Object)"1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = new Locale[]{Locale.ENGLISH, new Locale("tr", "", ""), Locale.getDefault()};
        String[][] data = new String[][]{{"i", "I"}, {"\u03c2", "\u03c3"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}};
        try {
            for (Locale locale : locales) {
                Locale.setDefault(locale);
                for (int j = 0; j < data.length; ++j) {
                    CaseInsensitiveMapTest.assertTrue((String)("Test data corrupt: " + j), (boolean)data[j][0].equalsIgnoreCase(data[j][1]));
                    CaseInsensitiveMap map = new CaseInsensitiveMap();
                    map.put((Object)data[j][0], (Object)"value");
                    CaseInsensitiveMapTest.assertEquals((String)(Locale.getDefault() + ": " + j), (String)"value", (String)((String)map.get((Object)data[j][1])));
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }

    public void testInitialCapacityZero() {
        CaseInsensitiveMap map = new CaseInsensitiveMap(0);
        CaseInsensitiveMapTest.assertEquals((int)1, (int)map.data.length);
    }
}

