/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.collections4.multimap.UnmodifiableMultiValuedMap;

public class UnmodifiableMultiValuedMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    public UnmodifiableMultiValuedMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableMultiValuedMapTest.class);
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public MultiValuedMap<K, V> makeObject() {
        return UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap((MultiValuedMap)new ArrayListValuedHashMap());
    }

    @Override
    protected MultiValuedMap<K, V> makeFullMap() {
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        this.addSampleMappings(map);
        return UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap((MultiValuedMap)map);
    }

    public void testUnmodifiable() {
        UnmodifiableMultiValuedMapTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableMultiValuedMapTest.assertTrue((boolean)(this.makeFullMap() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        MultiValuedMap<K, V> map = this.makeFullMap();
        UnmodifiableMultiValuedMapTest.assertSame(map, (Object)UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap(map));
    }

    public void testDecoratorFactoryNullMap() {
        try {
            UnmodifiableMultiValuedMap.unmodifiableMultiValuedMap(null);
            UnmodifiableMultiValuedMapTest.fail((String)"map must not be null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testAddException() {
        MultiValuedMap<K, V> map = this.makeObject();
        try {
            map.put((Object)"one", (Object)"uno");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableEntries() {
        this.resetFull();
        Collection entries = this.getMap().entries();
        try {
            entries.clear();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator it = entries.iterator();
        Map.Entry entry = (Map.Entry)it.next();
        try {
            it.remove();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            entry.setValue("three");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableMapIterator() {
        this.resetFull();
        MapIterator mapIt = this.getMap().mapIterator();
        try {
            mapIt.remove();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            mapIt.setValue((Object)"three");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableKeySet() {
        this.resetFull();
        Set keySet = this.getMap().keySet();
        try {
            keySet.add("four");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            keySet.remove("four");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            keySet.clear();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator it = keySet.iterator();
        try {
            it.remove();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableValues() {
        this.resetFull();
        Collection values = this.getMap().values();
        try {
            values.add("four");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            values.remove("four");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            values.clear();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator it = values.iterator();
        try {
            it.remove();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableAsMap() {
        this.resetFull();
        Map mapCol = this.getMap().asMap();
        try {
            mapCol.put("four", Arrays.asList("four"));
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            mapCol.remove("four");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            mapCol.clear();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            mapCol.clear();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiableKeys() {
        this.resetFull();
        MultiSet keys = this.getMap().keys();
        try {
            keys.add((Object)"four");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            keys.remove((Object)"four");
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            keys.clear();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator it = keys.iterator();
        try {
            it.remove();
            UnmodifiableMultiValuedMapTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

