/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.TransformedCollection;

public class TransformedCollectionTest
extends AbstractCollectionTest<Object> {
    public static final Transformer<Object, Object> NOOP_TRANSFORMER = TransformerUtils.nopTransformer();
    public static final Transformer<Object, Object> STRING_TO_INTEGER_TRANSFORMER = new StringToInteger();

    public TransformedCollectionTest(String testName) {
        super(testName);
    }

    @Override
    public Collection<Object> makeConfirmedCollection() {
        return new ArrayList<Object>();
    }

    @Override
    public Collection<Object> makeConfirmedFullCollection() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public Collection<Object> makeObject() {
        return TransformedCollection.transformingCollection(new ArrayList(), NOOP_TRANSFORMER);
    }

    @Override
    public Collection<Object> makeFullCollection() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(this.getFullElements()));
        return TransformedCollection.transformingCollection(list, NOOP_TRANSFORMER);
    }

    @Override
    public Object[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    @Override
    public Object[] getOtherElements() {
        return new Object[]{"9", "88", "678", "87", "98", "78", "99"};
    }

    public void testTransformedCollection() {
        TransformedCollection coll = TransformedCollection.transformingCollection(new ArrayList(), STRING_TO_INTEGER_TRANSFORMER);
        TransformedCollectionTest.assertEquals((int)0, (int)coll.size());
        Object[] elements = this.getFullElements();
        for (int i = 0; i < elements.length; ++i) {
            coll.add(elements[i]);
            TransformedCollectionTest.assertEquals((int)(i + 1), (int)coll.size());
            TransformedCollectionTest.assertEquals((boolean)true, (boolean)coll.contains(Integer.valueOf((String)elements[i])));
            TransformedCollectionTest.assertEquals((boolean)false, (boolean)coll.contains(elements[i]));
        }
        TransformedCollectionTest.assertEquals((boolean)true, (boolean)coll.remove(Integer.valueOf((String)elements[0])));
    }

    public void testTransformedCollection_decorateTransform() {
        ArrayList originalCollection = new ArrayList();
        Object[] elements = this.getFullElements();
        Collections.addAll(originalCollection, elements);
        TransformedCollection collection = TransformedCollection.transformedCollection(originalCollection, STRING_TO_INTEGER_TRANSFORMER);
        TransformedCollectionTest.assertEquals((int)elements.length, (int)collection.size());
        for (Object element : elements) {
            TransformedCollectionTest.assertEquals((boolean)true, (boolean)collection.contains(Integer.valueOf((String)element)));
            TransformedCollectionTest.assertEquals((boolean)false, (boolean)collection.contains(element));
        }
        TransformedCollectionTest.assertEquals((boolean)false, (boolean)collection.remove(elements[0]));
        TransformedCollectionTest.assertEquals((boolean)true, (boolean)collection.remove(Integer.valueOf((String)elements[0])));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    private static class StringToInteger
    implements Transformer<Object, Object> {
        private StringToInteger() {
        }

        public Object transform(Object input) {
            return Integer.valueOf((String)input);
        }
    }
}

