/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.BoundedCollection;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.UnmodifiableBoundedCollection;
import org.apache.commons.collections4.list.FixedSizeList;

public class UnmodifiableBoundedCollectionTest<E>
extends AbstractCollectionTest<E> {
    public UnmodifiableBoundedCollectionTest(String testName) {
        super(testName);
    }

    @Override
    public Collection<E> makeObject() {
        FixedSizeList coll = FixedSizeList.fixedSizeList(new ArrayList());
        return UnmodifiableBoundedCollection.unmodifiableBoundedCollection((BoundedCollection)coll);
    }

    @Override
    public BoundedCollection<E> makeFullCollection() {
        E[] allElements = this.getFullElements();
        FixedSizeList coll = FixedSizeList.fixedSizeList(new ArrayList(Arrays.asList(allElements)));
        return UnmodifiableBoundedCollection.unmodifiableBoundedCollection((BoundedCollection)coll);
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    protected boolean skipSerializedCanonicalTests() {
        return true;
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    public void testUnmodifiable() {
        UnmodifiableBoundedCollectionTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableBoundedCollectionTest.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        BoundedCollection<E> coll = this.makeFullCollection();
        UnmodifiableBoundedCollectionTest.assertSame(coll, (Object)UnmodifiableBoundedCollection.unmodifiableBoundedCollection(coll));
        try {
            UnmodifiableBoundedCollection.unmodifiableBoundedCollection(null);
            UnmodifiableBoundedCollectionTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

