/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.commons.collections4.collection.TransformedCollectionTest;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.TransformedSortedMap;

public class TransformedSortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    public TransformedSortedMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(TransformedSortedMapTest.class);
    }

    @Override
    public String[] ignoredTests() {
        if (IBMJDK16) {
            String preSubMap = "TransformedSortedMapTest.bulkTestSubMap.";
            String preTailMap = "TransformedSortedMapTest.bulkTestTailMap.";
            return new String[]{"TransformedSortedMapTest.bulkTestSubMap.bulkTestMapEntrySet.testCollectionIteratorRemove", "TransformedSortedMapTest.bulkTestSubMap.bulkTestMapKeySet.testCollectionRemove", "TransformedSortedMapTest.bulkTestSubMap.bulkTestMapValues.testCollectionIteratorRemove", "TransformedSortedMapTest.bulkTestTailMap.testMapRemove", "TransformedSortedMapTest.bulkTestTailMap.bulkTestMapEntrySet.testCollectionIteratorRemove", "TransformedSortedMapTest.bulkTestTailMap.bulkTestMapEntrySet.testCollectionRemoveAll", "TransformedSortedMapTest.bulkTestTailMap.bulkTestMapKeySet.testCollectionIteratorRemove", "TransformedSortedMapTest.bulkTestTailMap.bulkTestMapKeySet.testCollectionRemoveAll", "TransformedSortedMapTest.bulkTestTailMap.bulkTestMapValues.testCollectionClear", "TransformedSortedMapTest.bulkTestTailMap.bulkTestMapValues.testCollectionRemoveAll", "TransformedSortedMapTest.bulkTestTailMap.bulkTestMapValues.testCollectionRetainAll"};
        }
        return null;
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return TransformedSortedMap.transformingSortedMap(new TreeMap(), (Transformer)TransformerUtils.nopTransformer(), (Transformer)TransformerUtils.nopTransformer());
    }

    @Override
    public boolean isSubMapViewsSerializable() {
        return false;
    }

    public void testTransformedMap() {
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "6"};
        TransformedSortedMap map = TransformedSortedMap.transformingSortedMap(new TreeMap(), TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER, null);
        TransformedSortedMapTest.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            TransformedSortedMapTest.assertEquals((int)(i + 1), (int)map.size());
            TransformedSortedMapTest.assertEquals((boolean)true, (boolean)map.containsKey(Integer.valueOf((String)els[i])));
            try {
                map.containsKey(els[i]);
                TransformedSortedMapTest.fail();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            TransformedSortedMapTest.assertEquals((boolean)true, (boolean)map.containsValue(els[i]));
            TransformedSortedMapTest.assertEquals((Object)els[i], map.get(Integer.valueOf((String)els[i])));
        }
        try {
            map.remove(els[0]);
            TransformedSortedMapTest.fail();
        }
        catch (ClassCastException i) {
            // empty catch block
        }
        TransformedSortedMapTest.assertEquals((Object)els[0], map.remove(Integer.valueOf((String)els[0])));
        map = TransformedSortedMap.transformingSortedMap(new TreeMap(), null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSortedMapTest.assertEquals((int)0, (int)map.size());
        for (int i = 0; i < els.length; ++i) {
            map.put(els[i], els[i]);
            TransformedSortedMapTest.assertEquals((int)(i + 1), (int)map.size());
            TransformedSortedMapTest.assertEquals((boolean)true, (boolean)map.containsValue(Integer.valueOf((String)els[i])));
            TransformedSortedMapTest.assertEquals((boolean)false, (boolean)map.containsValue(els[i]));
            TransformedSortedMapTest.assertEquals((boolean)true, (boolean)map.containsKey(els[i]));
            TransformedSortedMapTest.assertEquals((Object)Integer.valueOf((String)els[i]), map.get(els[i]));
        }
        TransformedSortedMapTest.assertEquals((Object)Integer.valueOf((String)els[0]), map.remove(els[0]));
        Set entrySet = map.entrySet();
        Map.Entry[] array = entrySet.toArray(new Map.Entry[0]);
        array[0].setValue("66");
        TransformedSortedMapTest.assertEquals((Object)66, array[0].getValue());
        TransformedSortedMapTest.assertEquals((Object)66, map.get(array[0].getKey()));
        Map.Entry entry = entrySet.iterator().next();
        entry.setValue("88");
        TransformedSortedMapTest.assertEquals((Object)88, entry.getValue());
        TransformedSortedMapTest.assertEquals((Object)88, map.get(entry.getKey()));
    }

    public void testFactory_Decorate() {
        TreeMap<String, String> base = new TreeMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedSortedMap trans = TransformedSortedMap.transformingSortedMap(base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSortedMapTest.assertEquals((int)3, (int)trans.size());
        TransformedSortedMapTest.assertEquals((Object)"1", trans.get("A"));
        TransformedSortedMapTest.assertEquals((Object)"2", trans.get("B"));
        TransformedSortedMapTest.assertEquals((Object)"3", trans.get("C"));
        trans.put("D", "4");
        TransformedSortedMapTest.assertEquals((Object)4, trans.get("D"));
    }

    public void testFactory_decorateTransform() {
        TreeMap<String, String> base = new TreeMap<String, String>();
        base.put("A", "1");
        base.put("B", "2");
        base.put("C", "3");
        TransformedSortedMap trans = TransformedSortedMap.transformedSortedMap(base, null, TransformedCollectionTest.STRING_TO_INTEGER_TRANSFORMER);
        TransformedSortedMapTest.assertEquals((int)3, (int)trans.size());
        TransformedSortedMapTest.assertEquals((Object)1, trans.get("A"));
        TransformedSortedMapTest.assertEquals((Object)2, trans.get("B"));
        TransformedSortedMapTest.assertEquals((Object)3, trans.get("C"));
        trans.put("D", "4");
        TransformedSortedMapTest.assertEquals((Object)4, trans.get("D"));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

