/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.commons.collections4.set.AbstractSetTest;

public abstract class AbstractMultiSetTest<T>
extends AbstractCollectionTest<T> {
    public AbstractMultiSetTest(String testName) {
        super(testName);
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> coll = this.makeConfirmedCollection();
        coll.addAll(Arrays.asList(this.getFullElements()));
        return coll;
    }

    @Override
    public abstract MultiSet<T> makeObject();

    @Override
    public MultiSet<T> makeFullCollection() {
        MultiSet<T> multiset = this.makeObject();
        multiset.addAll(Arrays.asList(this.getFullElements()));
        return multiset;
    }

    @Override
    public void resetEmpty() {
        this.setCollection(this.makeObject());
        this.setConfirmed(this.makeConfirmedCollection());
    }

    @Override
    public void resetFull() {
        this.setCollection(this.makeFullCollection());
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    @Override
    public MultiSet<T> getCollection() {
        return (MultiSet)super.getCollection();
    }

    public void testMultiSetAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertTrue((String)"Should contain 'A'", (boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"Should have count of 1", (int)1, (int)multiset.getCount((Object)"A"));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertTrue((String)"Should contain 'A'", (boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"Should have count of 2", (int)2, (int)multiset.getCount((Object)"A"));
        multiset.add((Object)"B");
        AbstractMultiSetTest.assertTrue((boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertTrue((boolean)multiset.contains((Object)"B"));
    }

    public void testMultiSetEqualsSelf() {
        MultiSet<T> multiset = this.makeObject();
        AbstractMultiSetTest.assertTrue((boolean)multiset.equals(multiset));
        if (!this.isAddSupported()) {
            return;
        }
        multiset.add((Object)"elt");
        AbstractMultiSetTest.assertTrue((boolean)multiset.equals(multiset));
        multiset.add((Object)"elt");
        AbstractMultiSetTest.assertTrue((boolean)multiset.equals(multiset));
        multiset.add((Object)"elt2");
        AbstractMultiSetTest.assertTrue((boolean)multiset.equals(multiset));
    }

    public void testMultiSetRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"Should have count of 1", (int)1, (int)multiset.getCount((Object)"A"));
        multiset.remove((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"Should have count of 0", (int)0, (int)multiset.getCount((Object)"A"));
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"Should have count of 4", (int)4, (int)multiset.getCount((Object)"A"));
        multiset.remove((Object)"A", 0);
        AbstractMultiSetTest.assertEquals((String)"Should have count of 4", (int)4, (int)multiset.getCount((Object)"A"));
        multiset.remove((Object)"A", 2);
        AbstractMultiSetTest.assertEquals((String)"Should have count of 2", (int)2, (int)multiset.getCount((Object)"A"));
        multiset.remove((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"Should have count of 1", (int)1, (int)multiset.getCount((Object)"A"));
    }

    public void testMultiSetRemoveAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A", 2);
        AbstractMultiSetTest.assertEquals((String)"Should have count of 2", (int)2, (int)multiset.getCount((Object)"A"));
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        AbstractMultiSetTest.assertEquals((String)"Should have count of 4", (int)4, (int)multiset.size());
        ArrayList<String> delete = new ArrayList<String>();
        delete.add("A");
        delete.add("B");
        multiset.removeAll(delete);
        AbstractMultiSetTest.assertEquals((String)"Should have count of 0", (int)0, (int)multiset.getCount((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"Should have count of 0", (int)0, (int)multiset.getCount((Object)"B"));
        AbstractMultiSetTest.assertEquals((String)"Should have count of 1", (int)1, (int)multiset.getCount((Object)"C"));
        AbstractMultiSetTest.assertEquals((String)"Should have count of 1", (int)1, (int)multiset.size());
    }

    public void testMultiSetContains() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not have at least 1 'A'", (boolean)false, (boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not have at least 1 'B'", (boolean)false, (boolean)multiset.contains((Object)"B"));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"MultiSet has at least 1 'A'", (boolean)true, (boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not have at least 1 'B'", (boolean)false, (boolean)multiset.contains((Object)"B"));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"MultiSet has at least 1 'A'", (boolean)true, (boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not have at least 1 'B'", (boolean)false, (boolean)multiset.contains((Object)"B"));
        multiset.add((Object)"B");
        AbstractMultiSetTest.assertEquals((String)"MultiSet has at least 1 'A'", (boolean)true, (boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"MultiSet has at least 1 'B'", (boolean)true, (boolean)multiset.contains((Object)"B"));
    }

    public void testMultiSetContainsAll() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        ArrayList known = new ArrayList();
        ArrayList<String> known1A = new ArrayList<String>();
        known1A.add("A");
        ArrayList<String> known2A = new ArrayList<String>();
        known2A.add("A");
        known2A.add("A");
        ArrayList<String> known1B = new ArrayList<String>();
        known1B.add("B");
        ArrayList<String> known1A1B = new ArrayList<String>();
        known1A1B.add("A");
        known1A1B.add("B");
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of empty", (boolean)true, (boolean)multiset.containsAll(known));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'A'", (boolean)false, (boolean)multiset.containsAll(known1A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 2 'A'", (boolean)false, (boolean)multiset.containsAll(known2A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1B));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1A1B));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of empty", (boolean)true, (boolean)multiset.containsAll(known));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 1 'A'", (boolean)true, (boolean)multiset.containsAll(known1A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll 'A'", (boolean)true, (boolean)multiset.containsAll(known2A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1B));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1A1B));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of empty", (boolean)true, (boolean)multiset.containsAll(known));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 1 'A'", (boolean)true, (boolean)multiset.containsAll(known1A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 2 'A'", (boolean)true, (boolean)multiset.containsAll(known2A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1B));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1A1B));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of empty", (boolean)true, (boolean)multiset.containsAll(known));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 1 'A'", (boolean)true, (boolean)multiset.containsAll(known1A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 2 'A'", (boolean)true, (boolean)multiset.containsAll(known2A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1B));
        AbstractMultiSetTest.assertEquals((String)"MultiSet does not containsAll of 1 'A' 1 'B'", (boolean)false, (boolean)multiset.containsAll(known1A1B));
        multiset.add((Object)"B");
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of empty", (boolean)true, (boolean)multiset.containsAll(known));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 1 'A'", (boolean)true, (boolean)multiset.containsAll(known1A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 2 'A'", (boolean)true, (boolean)multiset.containsAll(known2A));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 1 'B'", (boolean)true, (boolean)multiset.containsAll(known1B));
        AbstractMultiSetTest.assertEquals((String)"MultiSet containsAll of 1 'A' 1 'B'", (boolean)true, (boolean)multiset.containsAll(known1A1B));
    }

    public void testMultiSetSize() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        AbstractMultiSetTest.assertEquals((String)"Should have 0 total items", (int)0, (int)multiset.size());
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"Should have 1 total items", (int)1, (int)multiset.size());
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"Should have 2 total items", (int)2, (int)multiset.size());
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((String)"Should have 3 total items", (int)3, (int)multiset.size());
        multiset.add((Object)"B");
        AbstractMultiSetTest.assertEquals((String)"Should have 4 total items", (int)4, (int)multiset.size());
        multiset.add((Object)"B");
        AbstractMultiSetTest.assertEquals((String)"Should have 5 total items", (int)5, (int)multiset.size());
        multiset.remove((Object)"A", 2);
        AbstractMultiSetTest.assertEquals((String)"Should have 1 'A'", (int)1, (int)multiset.getCount((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"Should have 3 total items", (int)3, (int)multiset.size());
        multiset.remove((Object)"B");
        AbstractMultiSetTest.assertEquals((String)"Should have 2 total item", (int)2, (int)multiset.size());
    }

    public void testMultiSetRetainAll() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        ArrayList<String> retains = new ArrayList<String>();
        retains.add("B");
        retains.add("C");
        multiset.retainAll(retains);
        AbstractMultiSetTest.assertEquals((String)"Should have 3 total items", (int)3, (int)multiset.size());
    }

    public void testMultiSetIterator() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        AbstractMultiSetTest.assertEquals((String)"MultiSet should have 3 items", (int)3, (int)multiset.size());
        Iterator i = multiset.iterator();
        boolean foundA = false;
        while (i.hasNext()) {
            String element = (String)i.next();
            if (!element.equals("A")) continue;
            if (!foundA) {
                foundA = true;
                continue;
            }
            i.remove();
        }
        AbstractMultiSetTest.assertTrue((String)"MultiSet should still contain 'A'", (boolean)multiset.contains((Object)"A"));
        AbstractMultiSetTest.assertEquals((String)"MultiSet should have 2 items", (int)2, (int)multiset.size());
        AbstractMultiSetTest.assertEquals((String)"MultiSet should have 1 'A'", (int)1, (int)multiset.getCount((Object)"A"));
    }

    public void testMultiSetIteratorFail() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        Iterator it = multiset.iterator();
        it.next();
        multiset.remove((Object)"A");
        try {
            it.next();
            AbstractMultiSetTest.fail((String)"Should throw ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testMultiSetIteratorFailNoMore() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        Iterator it = multiset.iterator();
        it.next();
        it.next();
        it.next();
        try {
            it.next();
            AbstractMultiSetTest.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testMultiSetIteratorFailDoubleRemove() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        Iterator it = multiset.iterator();
        it.next();
        it.next();
        AbstractMultiSetTest.assertEquals((int)3, (int)multiset.size());
        it.remove();
        AbstractMultiSetTest.assertEquals((int)2, (int)multiset.size());
        try {
            it.remove();
            AbstractMultiSetTest.fail((String)"Should throw IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbstractMultiSetTest.assertEquals((int)2, (int)multiset.size());
        it.next();
        it.remove();
        AbstractMultiSetTest.assertEquals((int)1, (int)multiset.size());
    }

    public void testMultiSetIteratorRemoveProtectsInvariants() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((int)2, (int)multiset.size());
        Iterator it = multiset.iterator();
        AbstractMultiSetTest.assertEquals((Object)"A", it.next());
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)it.hasNext());
        it.remove();
        AbstractMultiSetTest.assertEquals((int)1, (int)multiset.size());
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)it.hasNext());
        AbstractMultiSetTest.assertEquals((Object)"A", it.next());
        AbstractMultiSetTest.assertEquals((boolean)false, (boolean)it.hasNext());
        it.remove();
        AbstractMultiSetTest.assertEquals((int)0, (int)multiset.size());
        AbstractMultiSetTest.assertEquals((boolean)false, (boolean)it.hasNext());
        Iterator it2 = multiset.iterator();
        AbstractMultiSetTest.assertEquals((boolean)false, (boolean)it2.hasNext());
    }

    public void testMultiSetToArray() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        Object[] array = multiset.toArray();
        int a = 0;
        int b = 0;
        int c = 0;
        for (Object element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        AbstractMultiSetTest.assertEquals((int)2, (int)a);
        AbstractMultiSetTest.assertEquals((int)2, (int)b);
        AbstractMultiSetTest.assertEquals((int)1, (int)c);
    }

    public void testMultiSetToArrayPopulate() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        String[] array = (String[])multiset.toArray((Object[])new String[0]);
        int a = 0;
        int b = 0;
        int c = 0;
        for (String element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        AbstractMultiSetTest.assertEquals((int)2, (int)a);
        AbstractMultiSetTest.assertEquals((int)2, (int)b);
        AbstractMultiSetTest.assertEquals((int)1, (int)c);
    }

    public void testMultiSetEquals() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        MultiSet<T> multiset2 = this.makeObject();
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)multiset.equals(multiset2));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((boolean)false, (boolean)multiset.equals(multiset2));
        multiset2.add((Object)"A");
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)multiset.equals(multiset2));
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        multiset2.add((Object)"A");
        multiset2.add((Object)"B");
        multiset2.add((Object)"B");
        multiset2.add((Object)"C");
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)multiset.equals(multiset2));
    }

    public void testMultiSetEqualsHashMultiSet() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        HashMultiSet multiset2 = new HashMultiSet();
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)multiset.equals((Object)multiset2));
        multiset.add((Object)"A");
        AbstractMultiSetTest.assertEquals((boolean)false, (boolean)multiset.equals((Object)multiset2));
        multiset2.add((Object)"A");
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)multiset.equals((Object)multiset2));
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        multiset2.add((Object)"A");
        multiset2.add((Object)"B");
        multiset2.add((Object)"B");
        multiset2.add((Object)"C");
        AbstractMultiSetTest.assertEquals((boolean)true, (boolean)multiset.equals((Object)multiset2));
    }

    public void testMultiSetHashCode() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        MultiSet<T> multiset2 = this.makeObject();
        AbstractMultiSetTest.assertEquals((int)0, (int)multiset.hashCode());
        AbstractMultiSetTest.assertEquals((int)0, (int)multiset2.hashCode());
        AbstractMultiSetTest.assertEquals((int)multiset.hashCode(), (int)multiset2.hashCode());
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        multiset2.add((Object)"A");
        multiset2.add((Object)"A");
        multiset2.add((Object)"B");
        multiset2.add((Object)"B");
        multiset2.add((Object)"C");
        AbstractMultiSetTest.assertEquals((int)multiset.hashCode(), (int)multiset2.hashCode());
        int total = 0;
        total += "A".hashCode() ^ 2;
        total += "B".hashCode() ^ 2;
        AbstractMultiSetTest.assertEquals((int)(total += "C".hashCode() ^ 1), (int)multiset.hashCode());
        AbstractMultiSetTest.assertEquals((int)total, (int)multiset2.hashCode());
    }

    public BulkTest bulkTestMultiSetUniqueSet() {
        return new TestMultiSetUniqueSet();
    }

    public void testEmptyMultiSetCompatibility() throws IOException, ClassNotFoundException {
        MultiSet<T> multiset = this.makeObject();
        if (multiset instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            MultiSet multiset2 = (MultiSet)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(multiset));
            AbstractMultiSetTest.assertTrue((String)"MultiSet is empty", (multiset2.size() == 0 ? 1 : 0) != 0);
            AbstractMultiSetTest.assertEquals(multiset, (Object)multiset2);
        }
    }

    public void testFullMultiSetCompatibility() throws IOException, ClassNotFoundException {
        MultiSet<T> multiset = this.makeFullCollection();
        if (multiset instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            MultiSet multiset2 = (MultiSet)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(multiset));
            AbstractMultiSetTest.assertEquals((String)"MultiSet is the right size", (int)multiset.size(), (int)multiset2.size());
            AbstractMultiSetTest.assertEquals(multiset, (Object)multiset2);
        }
    }

    public class TestMultiSetUniqueSet
    extends AbstractSetTest<T> {
        public TestMultiSetUniqueSet() {
            super("");
        }

        @Override
        public T[] getFullElements() {
            return AbstractMultiSetTest.this.getFullElements();
        }

        @Override
        public T[] getOtherElements() {
            return AbstractMultiSetTest.this.getOtherElements();
        }

        @Override
        public Set<T> makeObject() {
            return AbstractMultiSetTest.this.makeObject().uniqueSet();
        }

        @Override
        public Set<T> makeFullCollection() {
            return AbstractMultiSetTest.this.makeFullCollection().uniqueSet();
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiSetTest.this.isNullSupported();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiSetTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetEmpty() {
            AbstractMultiSetTest.this.resetEmpty();
            this.setCollection(AbstractMultiSetTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractMultiSetTest.this.getConfirmed()));
        }

        @Override
        public void resetFull() {
            AbstractMultiSetTest.this.resetFull();
            this.setCollection(AbstractMultiSetTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractMultiSetTest.this.getConfirmed()));
        }

        @Override
        public void verify() {
            super.verify();
        }
    }
}

