/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.MapBackedSet;

public class MapBackedSet2Test<E>
extends AbstractSetTest<E> {
    public MapBackedSet2Test(String testName) {
        super(testName);
    }

    @Override
    public Set<E> makeObject() {
        return MapBackedSet.mapBackedSet((Map)new LinkedMap());
    }

    protected Set<E> setupSet() {
        Collection set = this.makeObject();
        for (int i = 0; i < 10; ++i) {
            set.add(Integer.toString(i));
        }
        return set;
    }

    public void testOrdering() {
        int i;
        Set<String> set = this.setupSet();
        Iterator<E> it = set.iterator();
        for (i = 0; i < 10; ++i) {
            MapBackedSet2Test.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; i += 2) {
            MapBackedSet2Test.assertTrue((String)"Must be able to remove int", (boolean)set.remove(Integer.toString(i)));
        }
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            MapBackedSet2Test.assertEquals((String)"Sequence is wrong after remove ", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; ++i) {
            set.add(Integer.toString(i));
        }
        MapBackedSet2Test.assertEquals((String)"Size of set is wrong!", (int)10, (int)set.size());
        it = set.iterator();
        for (i = 1; i < 10; i += 2) {
            MapBackedSet2Test.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
        for (i = 0; i < 10; i += 2) {
            MapBackedSet2Test.assertEquals((String)"Sequence is wrong", (Object)Integer.toString(i), it.next());
        }
    }

    @Override
    public void testCanonicalEmptyCollectionExists() {
    }

    @Override
    public void testCanonicalFullCollectionExists() {
    }
}

