/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.map.AbstractOrderedMapTest;
import org.apache.commons.collections4.map.ListOrderedMap;

public class ListOrderedMapTest<K, V>
extends AbstractOrderedMapTest<K, V> {
    public ListOrderedMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(ListOrderedMapTest.class);
    }

    @Override
    public ListOrderedMap<K, V> makeObject() {
        return ListOrderedMap.listOrderedMap(new HashMap());
    }

    @Override
    public ListOrderedMap<K, V> makeFullMap() {
        return (ListOrderedMap)super.makeFullMap();
    }

    public void testGetByIndex() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.get(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lom = this.getMap();
        try {
            lom.get(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.get(lom.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            ListOrderedMapTest.assertSame((Object)it.next(), (Object)lom.get(i));
            ++i;
        }
    }

    public void testGetValueByIndex() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.getValue(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.getValue(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lom = this.getMap();
        try {
            lom.getValue(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.getValue(lom.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        int i = 0;
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            it.next();
            ListOrderedMapTest.assertSame((Object)it.getValue(), (Object)lom.getValue(i));
            ++i;
        }
    }

    public void testIndexOf() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        ListOrderedMapTest.assertEquals((int)-1, (int)lom.indexOf(this.getOtherKeys()));
        this.resetFull();
        lom = this.getMap();
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            ListOrderedMapTest.assertEquals((int)i, (int)lom.indexOf(list.get(i)));
        }
    }

    public void testSetValueByIndex() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.setValue(0, (Object)"");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.setValue(-1, (Object)"");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lom = this.getMap();
        try {
            lom.setValue(-1, (Object)"");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.setValue(lom.size(), (Object)"");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        for (int i = 0; i < lom.size(); ++i) {
            Object value = lom.getValue(i);
            Integer input = i;
            ListOrderedMapTest.assertEquals((Object)value, (Object)lom.setValue(i, (Object)input));
            ListOrderedMapTest.assertEquals((Object)input, (Object)lom.getValue(i));
        }
    }

    public void testRemoveByIndex() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.remove(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.remove(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.resetFull();
        lom = this.getMap();
        try {
            lom.remove(-1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.remove(lom.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        ArrayList<Object> list = new ArrayList<Object>();
        OrderedMapIterator it = lom.mapIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Object value = lom.get(key);
            ListOrderedMapTest.assertEquals((Object)value, (Object)lom.remove(i));
            list.remove(i);
            ListOrderedMapTest.assertEquals((boolean)false, (boolean)lom.containsKey(key));
        }
    }

    public void testPut_intObjectObject() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        try {
            lom.put(1, (Object)"testInsert1", (Object)"testInsert1v");
            ListOrderedMapTest.fail((String)"should not be able to insert at pos 1 in empty Map");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            lom.put(-1, (Object)"testInsert-1", (Object)"testInsert-1v");
            ListOrderedMapTest.fail((String)"should not be able to insert at pos -1 in empty Map");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        lom.put(0, (Object)"testInsert1", (Object)"testInsert1v");
        ListOrderedMapTest.assertEquals((Object)"testInsert1v", (Object)lom.getValue(0));
        lom.put((Object)"testInsertPut", (Object)"testInsertPutv");
        ListOrderedMapTest.assertEquals((Object)"testInsert1v", (Object)lom.getValue(0));
        ListOrderedMapTest.assertEquals((Object)"testInsertPutv", (Object)lom.getValue(1));
        lom.put(0, (Object)"testInsert0", (Object)"testInsert0v");
        ListOrderedMapTest.assertEquals((Object)"testInsert0v", (Object)lom.getValue(0));
        ListOrderedMapTest.assertEquals((Object)"testInsert1v", (Object)lom.getValue(1));
        ListOrderedMapTest.assertEquals((Object)"testInsertPutv", (Object)lom.getValue(2));
        lom.put(3, (Object)"testInsert3", (Object)"testInsert3v");
        ListOrderedMapTest.assertEquals((Object)"testInsert0v", (Object)lom.getValue(0));
        ListOrderedMapTest.assertEquals((Object)"testInsert1v", (Object)lom.getValue(1));
        ListOrderedMapTest.assertEquals((Object)"testInsertPutv", (Object)lom.getValue(2));
        ListOrderedMapTest.assertEquals((Object)"testInsert3v", (Object)lom.getValue(3));
        this.resetFull();
        lom = this.getMap();
        ListOrderedMap lom2 = new ListOrderedMap();
        lom2.putAll(lom);
        lom2.put(0, (Object)"testInsert0", (Object)"testInsert0v");
        ListOrderedMapTest.assertEquals((Object)"testInsert0v", (Object)lom2.getValue(0));
        for (int i = 0; i < lom.size(); ++i) {
            ListOrderedMapTest.assertEquals((Object)lom2.getValue(i + 1), (Object)lom.getValue(i));
        }
        Integer i1 = 1;
        Integer i1b = 1;
        Integer i2 = 2;
        Integer i3 = 3;
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(0, (Object)i1, (Object)"One");
        ListOrderedMapTest.assertEquals((int)3, (int)lom.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.map.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.keyList().size());
        ListOrderedMapTest.assertEquals((Object)"One", (Object)lom.getValue(0));
        ListOrderedMapTest.assertSame((Object)i1, (Object)lom.get(0));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(0, (Object)i1b, (Object)"One");
        ListOrderedMapTest.assertEquals((int)3, (int)lom.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.map.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.keyList().size());
        ListOrderedMapTest.assertEquals((Object)"One", (Object)lom.getValue(0));
        ListOrderedMapTest.assertEquals((Object)"2", (Object)lom.getValue(1));
        ListOrderedMapTest.assertEquals((Object)"3", (Object)lom.getValue(2));
        ListOrderedMapTest.assertSame((Object)i1b, (Object)lom.get(0));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(1, (Object)i1b, (Object)"One");
        ListOrderedMapTest.assertEquals((int)3, (int)lom.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.map.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.keyList().size());
        ListOrderedMapTest.assertEquals((Object)"One", (Object)lom.getValue(0));
        ListOrderedMapTest.assertEquals((Object)"2", (Object)lom.getValue(1));
        ListOrderedMapTest.assertEquals((Object)"3", (Object)lom.getValue(2));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(2, (Object)i1b, (Object)"One");
        ListOrderedMapTest.assertEquals((int)3, (int)lom.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.map.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.keyList().size());
        ListOrderedMapTest.assertEquals((Object)"2", (Object)lom.getValue(0));
        ListOrderedMapTest.assertEquals((Object)"One", (Object)lom.getValue(1));
        ListOrderedMapTest.assertEquals((Object)"3", (Object)lom.getValue(2));
        this.resetEmpty();
        lom = this.getMap();
        lom.put((Object)i1, (Object)"1");
        lom.put((Object)i2, (Object)"2");
        lom.put((Object)i3, (Object)"3");
        lom.put(3, (Object)i1b, (Object)"One");
        ListOrderedMapTest.assertEquals((int)3, (int)lom.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.map.size());
        ListOrderedMapTest.assertEquals((int)3, (int)lom.keyList().size());
        ListOrderedMapTest.assertEquals((Object)"2", (Object)lom.getValue(0));
        ListOrderedMapTest.assertEquals((Object)"3", (Object)lom.getValue(1));
        ListOrderedMapTest.assertEquals((Object)"One", (Object)lom.getValue(2));
    }

    public void testPutAllWithIndex() {
        this.resetEmpty();
        ListOrderedMap lom = (ListOrderedMap)this.map;
        lom.put((Object)"testInsert0", (Object)"testInsert0v");
        lom.put((Object)"testInsert1", (Object)"testInsert1v");
        lom.put((Object)"testInsert2", (Object)"testInsert2v");
        ListOrderedMapTest.assertEquals((String)"testInsert0v", (String)((String)lom.getValue(0)));
        ListOrderedMapTest.assertEquals((String)"testInsert1v", (String)((String)lom.getValue(1)));
        ListOrderedMapTest.assertEquals((String)"testInsert2v", (String)((String)lom.getValue(2)));
        ListOrderedMap values = new ListOrderedMap();
        values.put("NewInsert0", "NewInsert0v");
        values.put("NewInsert1", "NewInsert1v");
        lom.putAll(1, (Map)values);
        ListOrderedMapTest.assertEquals((String)"testInsert0v", (String)((String)lom.getValue(0)));
        ListOrderedMapTest.assertEquals((String)"NewInsert0v", (String)((String)lom.getValue(1)));
        ListOrderedMapTest.assertEquals((String)"NewInsert1v", (String)((String)lom.getValue(2)));
        ListOrderedMapTest.assertEquals((String)"testInsert1v", (String)((String)lom.getValue(3)));
        ListOrderedMapTest.assertEquals((String)"testInsert2v", (String)((String)lom.getValue(4)));
    }

    public void testPutAllWithIndexBug441() {
        this.resetEmpty();
        ListOrderedMap<K, V> lom = this.getMap();
        int size = 5;
        for (int i = 0; i < 5; ++i) {
            lom.put((Object)i, (Object)Boolean.TRUE);
        }
        TreeMap<Integer, Boolean> map = new TreeMap<Integer, Boolean>();
        for (int i = 0; i < 5; ++i) {
            map.put(i, Boolean.FALSE);
        }
        lom.putAll(3, map);
        List orderedList = lom.asList();
        for (int i = 0; i < 5; ++i) {
            ListOrderedMapTest.assertEquals((Object)i, orderedList.get(i));
        }
    }

    public void testValueList_getByIndex() {
        this.resetFull();
        ListOrderedMap<K, V> lom = this.getMap();
        for (int i = 0; i < lom.size(); ++i) {
            Object expected = lom.getValue(i);
            ListOrderedMapTest.assertEquals((Object)expected, lom.valueList().get(i));
        }
    }

    public void testValueList_setByIndex() {
        this.resetFull();
        ListOrderedMap<K, V> lom = this.getMap();
        for (int i = 0; i < lom.size(); ++i) {
            Integer input = i;
            Object expected = lom.getValue(i);
            ListOrderedMapTest.assertEquals((Object)expected, (Object)lom.valueList().set(i, input));
            ListOrderedMapTest.assertEquals((Object)input, (Object)lom.getValue(i));
            ListOrderedMapTest.assertEquals((Object)input, lom.valueList().get(i));
        }
    }

    public void testValueList_removeByIndex() {
        this.resetFull();
        ListOrderedMap<K, V> lom = this.getMap();
        while (lom.size() > 1) {
            Object expected = lom.getValue(1);
            ListOrderedMapTest.assertEquals((Object)expected, lom.valueList().remove(1));
        }
    }

    public void testCOLLECTIONS_474_nullValues() {
        Object key1 = new Object();
        Object key2 = new Object();
        HashMap hmap = new HashMap();
        hmap.put(key1, null);
        hmap.put(key2, null);
        ListOrderedMapTest.assertEquals((String)"Should have two elements", (int)2, (int)hmap.size());
        ListOrderedMap listMap = new ListOrderedMap();
        listMap.put(key1, null);
        listMap.put(key2, null);
        ListOrderedMapTest.assertEquals((String)"Should have two elements", (int)2, (int)listMap.size());
        listMap.putAll(2, hmap);
    }

    public void testCOLLECTIONS_474_nonNullValues() {
        Object key1 = new Object();
        Object key2 = new Object();
        HashMap<Object, String> hmap = new HashMap<Object, String>();
        hmap.put(key1, "1");
        hmap.put(key2, "2");
        ListOrderedMapTest.assertEquals((String)"Should have two elements", (int)2, (int)hmap.size());
        ListOrderedMap listMap = new ListOrderedMap();
        listMap.put(key1, (Object)"3");
        listMap.put(key2, (Object)"4");
        ListOrderedMapTest.assertEquals((String)"Should have two elements", (int)2, (int)listMap.size());
        listMap.putAll(2, hmap);
    }

    public BulkTest bulkTestKeyListView() {
        return new TestKeyListView();
    }

    public BulkTest bulkTestValueListView() {
        return new TestValueListView();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public ListOrderedMap<K, V> getMap() {
        return (ListOrderedMap)super.getMap();
    }

    public class TestValueListView
    extends AbstractListTest<V> {
        TestValueListView() {
            super("TestValueListView");
        }

        @Override
        public List<V> makeObject() {
            return ListOrderedMapTest.this.makeObject().valueList();
        }

        @Override
        public List<V> makeFullCollection() {
            return ListOrderedMapTest.this.makeFullMap().valueList();
        }

        @Override
        public V[] getFullElements() {
            return ListOrderedMapTest.this.getSampleValues();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return true;
        }

        @Override
        public boolean isSetSupported() {
            return true;
        }

        @Override
        public boolean isNullSupported() {
            return ListOrderedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }
    }

    public class TestKeyListView
    extends AbstractListTest<K> {
        TestKeyListView() {
            super("TestKeyListView");
        }

        @Override
        public List<K> makeObject() {
            return ListOrderedMapTest.this.makeObject().keyList();
        }

        @Override
        public List<K> makeFullCollection() {
            return ListOrderedMapTest.this.makeFullMap().keyList();
        }

        @Override
        public K[] getFullElements() {
            return ListOrderedMapTest.this.getSampleKeys();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return false;
        }

        @Override
        public boolean isSetSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return ListOrderedMapTest.this.isAllowNullKey();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }
    }
}

