/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.set.AbstractNavigableSetTest;
import org.apache.commons.collections4.set.UnmodifiableNavigableSet;

public class UnmodifiableNavigableSetTest<E>
extends AbstractNavigableSetTest<E> {
    protected UnmodifiableNavigableSet<E> set = null;
    protected ArrayList<E> array = null;

    public UnmodifiableNavigableSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(UnmodifiableNavigableSetTest.class);
    }

    @Override
    public NavigableSet<E> makeObject() {
        return UnmodifiableNavigableSet.unmodifiableNavigableSet(new TreeSet());
    }

    @Override
    public UnmodifiableNavigableSet<E> makeFullCollection() {
        TreeSet set = new TreeSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return (UnmodifiableNavigableSet)UnmodifiableNavigableSet.unmodifiableNavigableSet(set);
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    protected void setupSet() {
        this.set = this.makeFullCollection();
        this.array = new ArrayList();
        this.array.add(1);
    }

    public void testUnmodifiable() {
        this.setupSet();
        this.verifyUnmodifiable((Set<E>)this.set);
        this.verifyUnmodifiable(this.set.descendingSet());
        this.verifyUnmodifiable(this.set.headSet((Object)1));
        this.verifyUnmodifiable(this.set.headSet((Object)1, true));
        this.verifyUnmodifiable(this.set.tailSet((Object)1));
        this.verifyUnmodifiable(this.set.tailSet((Object)1, false));
        this.verifyUnmodifiable(this.set.subSet((Object)1, (Object)3));
        this.verifyUnmodifiable(this.set.subSet((Object)1, false, (Object)3, false));
        this.verifyUnmodifiable(this.set.subSet((Object)1, true, (Object)3, true));
    }

    public void testDecorateFactory() {
        UnmodifiableNavigableSet<E> set = this.makeFullCollection();
        UnmodifiableNavigableSetTest.assertSame(set, (Object)UnmodifiableNavigableSet.unmodifiableNavigableSet(set));
        try {
            UnmodifiableNavigableSet.unmodifiableNavigableSet(null);
            UnmodifiableNavigableSetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void verifyUnmodifiable(Set<E> set) {
        try {
            set.add("value");
            UnmodifiableNavigableSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            set.addAll(new TreeSet());
            UnmodifiableNavigableSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            set.clear();
            UnmodifiableNavigableSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            set.remove("x");
            UnmodifiableNavigableSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            set.removeAll(this.array);
            UnmodifiableNavigableSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            set.retainAll(this.array);
            UnmodifiableNavigableSetTest.fail((String)"Expecting UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testComparator() {
        this.setupSet();
        Comparator c = this.set.comparator();
        UnmodifiableNavigableSetTest.assertTrue((String)"natural order, so comparator should be null", (c == null ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }
}

