/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.function.BiPredicate;
import java.util.function.Predicate;

class CountingPredicate<T>
implements Predicate<T> {
    private int idx;
    private final T[] ary;
    private final BiPredicate<T, T> func;

    CountingPredicate(T[] ary, BiPredicate<T, T> func) {
        this.ary = ary;
        this.func = func;
    }

    boolean forEachRemaining() {
        int i;
        T[] a = this.ary;
        int limit = a.length;
        for (i = this.idx; i != limit && this.func.test(a[i], null); ++i) {
        }
        return i == limit;
    }

    @Override
    public boolean test(T other) {
        return this.func.test(this.idx == this.ary.length ? null : (Object)this.ary[this.idx++], other);
    }
}

