/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.junit.Assert;
import org.junit.Test;

public class ChainingTestCase
extends AbstractTestCase {
    @Test
    public void testTarGzip() throws Exception {
        File file = ChainingTestCase.getFile("bla.tgz");
        TarArchiveInputStream is = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(file)));
        TarArchiveEntry entry = (TarArchiveEntry)is.getNextEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
        is.close();
    }

    @Test
    public void testTarBzip2() throws Exception {
        File file = ChainingTestCase.getFile("bla.tar.bz2");
        TarArchiveInputStream is = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(file)));
        TarArchiveEntry entry = (TarArchiveEntry)is.getNextEntry();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
        is.close();
    }
}

