/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@RunWith(value=PaxExam.class)
public class OsgiITest {
    private static final String EXPECTED_BUNDLE_NAME = "org.apache.commons.commons-compress";
    @Inject
    private BundleContext ctx;

    @Configuration
    public Option[] config() {
        return new Option[]{CoreOptions.systemProperty((String)"pax.exam.osgi.unresolved.fail").value("true"), CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.useFallbackRepositories").value("false"), CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.repositories").value("https://repo.maven.apache.org/maven2"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.scr").version("2.0.14"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.configadmin").version("1.8.16"), CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"pax.exam.invoker").value("junit"), CoreOptions.bundle((String)"link:classpath:META-INF/links/org.ops4j.pax.tipi.junit.link"), CoreOptions.bundle((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.invoker.junit.link"), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.hamcrest").version("1.3_1")}), (Option)CoreOptions.bundle((String)"reference:file:target/classes/").start()};
    }

    @Test
    public void loadBundle() {
        StringBuilder bundles = new StringBuilder();
        boolean foundCompressBundle = false;
        boolean first = true;
        for (Bundle b : this.ctx.getBundles()) {
            String symbolicName = b.getSymbolicName();
            foundCompressBundle |= EXPECTED_BUNDLE_NAME.equals(symbolicName);
            if (!first) {
                bundles.append(", ");
            }
            first = false;
            bundles.append(symbolicName);
        }
        Assert.assertTrue((String)("Expected to find bundle org.apache.commons.commons-compress in " + bundles), (boolean)foundCompressBundle);
    }
}

