/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.Assert;
import org.junit.Test;

public final class ZipTestCase
extends AbstractTestCase {
    String first_payload = "ABBA";
    String second_payload = "AAAAAAAAAAAA";
    ZipArchiveEntryPredicate allFilesPredicate = new ZipArchiveEntryPredicate(){

        public boolean test(ZipArchiveEntry zipArchiveEntry) {
            return true;
        }
    };

    @Test
    public void testZipArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.zip");
        File file1 = ZipTestCase.getFile("test1.xml");
        File file2 = ZipTestCase.getFile("test2.xml");
        try (FileOutputStream out = new FileOutputStream(output);
             ArchiveOutputStream os = new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)out);){
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
            try (FileInputStream input = new FileInputStream(file1);){
                IOUtils.copy((InputStream)input, (OutputStream)os);
            }
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
            input = new FileInputStream(file2);
            var9_15 = null;
            try {
                IOUtils.copy((InputStream)input, (OutputStream)os);
            }
            catch (Throwable throwable) {
                var9_15 = throwable;
                throw throwable;
            }
            finally {
                if (input != null) {
                    if (var9_15 != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable) {
                            var9_15.addSuppressed(throwable);
                        }
                    } else {
                        input.close();
                    }
                }
            }
            os.closeArchiveEntry();
        }
        ArrayList<File> results = new ArrayList<File>();
        try (FileInputStream fileInputStream = new FileInputStream(output);
             ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)fileInputStream);){
            ZipArchiveEntry entry = null;
            while ((entry = (ZipArchiveEntry)archiveInputStream.getNextEntry()) != null) {
                File outfile = new File(this.resultDir.getCanonicalPath() + "/result/" + entry.getName());
                outfile.getParentFile().mkdirs();
                try (FileOutputStream o = new FileOutputStream(outfile);){
                    IOUtils.copy((InputStream)archiveInputStream, (OutputStream)o);
                }
                results.add(outfile);
            }
        }
        Assert.assertEquals((long)results.size(), (long)2L);
        File result = (File)results.get(0);
        Assert.assertEquals((long)file1.length(), (long)result.length());
        result = (File)results.get(1);
        Assert.assertEquals((long)file2.length(), (long)result.length());
    }

    @Test
    public void testZipArchiveCreationInMemory() throws Exception {
        File file1 = ZipTestCase.getFile("test1.xml");
        File file2 = ZipTestCase.getFile("test2.xml");
        byte[] file1Contents = new byte[(int)file1.length()];
        byte[] file2Contents = new byte[(int)file2.length()];
        IOUtils.read((File)file1, (byte[])file1Contents);
        IOUtils.read((File)file2, (byte[])file2Contents);
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        try (SeekableInMemoryByteChannel channel = new SeekableInMemoryByteChannel();){
            try (ZipArchiveOutputStream os = new ZipArchiveOutputStream((SeekableByteChannel)channel);){
                os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
                os.write(file1Contents);
                os.closeArchiveEntry();
                os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
                os.write(file2Contents);
                os.closeArchiveEntry();
            }
            var9_11 = null;
            try (ArchiveInputStream inputStream = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)new ByteArrayInputStream(channel.array()));){
                ZipArchiveEntry entry;
                while ((entry = (ZipArchiveEntry)inputStream.getNextEntry()) != null) {
                    byte[] result = new byte[(int)entry.getSize()];
                    IOUtils.readFully((InputStream)inputStream, (byte[])result);
                    results.add(result);
                }
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
        }
        Assert.assertArrayEquals((byte[])((byte[])results.get(0)), (byte[])file1Contents);
        Assert.assertArrayEquals((byte[])((byte[])results.get(1)), (byte[])file2Contents);
    }

    @Test
    public void testZipUnarchive() throws Exception {
        File input = ZipTestCase.getFile("bla.zip");
        try (FileInputStream is = new FileInputStream(input);
             ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)is);){
            ZipArchiveEntry entry = (ZipArchiveEntry)in.getNextEntry();
            try (FileOutputStream out = new FileOutputStream(new File(this.dir, entry.getName()));){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    @Test
    public void testSkipsPK00Prefix() throws Exception {
        File input = ZipTestCase.getFile("COMPRESS-208.zip");
        ArrayList<String> al = new ArrayList<String>();
        al.add("test1.xml");
        al.add("test2.xml");
        try (FileInputStream fis = new FileInputStream(input);){
            this.checkArchiveContent((ArchiveInputStream)new ZipArchiveInputStream((InputStream)fis), al);
        }
    }

    @Test
    public void testTokenizationCompressionMethod() throws IOException {
        try (ZipFile moby = new ZipFile(ZipTestCase.getFile("moby.zip"));){
            ZipArchiveEntry entry = moby.getEntry("README");
            Assert.assertEquals((String)"method", (long)ZipMethod.TOKENIZATION.getCode(), (long)entry.getMethod());
            Assert.assertFalse((boolean)moby.canReadEntryData(entry));
        }
    }

    @Test
    public void testSkipEntryWithUnsupportedCompressionMethod() throws IOException {
        try (ZipArchiveInputStream zip = new ZipArchiveInputStream((InputStream)new FileInputStream(ZipTestCase.getFile("moby.zip")));){
            ZipArchiveEntry entry = zip.getNextZipEntry();
            Assert.assertEquals((String)"method", (long)ZipMethod.TOKENIZATION.getCode(), (long)entry.getMethod());
            Assert.assertEquals((Object)"README", (Object)entry.getName());
            Assert.assertFalse((boolean)zip.canReadEntryData((ArchiveEntry)entry));
            try {
                Assert.assertNull((Object)zip.getNextZipEntry());
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)"COMPRESS-93: Unable to skip an unsupported zip entry");
            }
        }
    }

    @Test
    public void testListAllFilesWithNestedArchive() throws Exception {
        File input = ZipTestCase.getFile("OSX_ArchiveWithNestedArchive.zip");
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<ZipException> expectedExceptions = new ArrayList<ZipException>();
        try (FileInputStream fis = new FileInputStream(input);
             ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)fis);){
            ZipArchiveEntry entry = null;
            while ((entry = (ZipArchiveEntry)in.getNextEntry()) != null) {
                results.add(entry.getName());
                ArchiveInputStream nestedIn = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)in);
                try {
                    ZipArchiveEntry nestedEntry = null;
                    while ((nestedEntry = (ZipArchiveEntry)nestedIn.getNextEntry()) != null) {
                        results.add(nestedEntry.getName());
                    }
                }
                catch (ZipException ex) {
                    expectedExceptions.add(ex);
                }
            }
        }
        Assert.assertTrue((boolean)results.contains("NestedArchiv.zip"));
        Assert.assertTrue((boolean)results.contains("test1.xml"));
        Assert.assertTrue((boolean)results.contains("test2.xml"));
        Assert.assertTrue((boolean)results.contains("test3.xml"));
        Assert.assertEquals((long)1L, (long)expectedExceptions.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            long beforeArchiveWrite = tmp[0].lastModified();
            ZipArchiveEntry in = new ZipArchiveEntry(tmp[0], "foo");
            zos.putArchiveEntry((ArchiveEntry)in);
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo/");
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo/", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            long beforeArchiveWrite = tmp[0].lastModified();
            ZipArchiveEntry in = new ZipArchiveEntry("foo/");
            in.setTime(beforeArchiveWrite);
            zos.putArchiveEntry((ArchiveEntry)in);
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo/");
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo/", (Object)out.getName());
            Assert.assertEquals((long)0L, (long)out.getSize());
            Assert.assertEquals((long)(beforeArchiveWrite / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assert.assertTrue((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }

    @Test
    public void testCopyRawEntriesFromFile() throws IOException {
        File[] tmp = this.createTempDirAndFile();
        File reference = this.createReferenceFile(tmp[0], Zip64Mode.Never, "expected.");
        File file1 = File.createTempFile("src1.", ".zip", tmp[0]);
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(file1);){
            zos.setUseZip64(Zip64Mode.Never);
            this.createFirstEntry(zos).close();
        }
        File file2 = File.createTempFile("src2.", ".zip", tmp[0]);
        try (ZipArchiveOutputStream zos1 = new ZipArchiveOutputStream(file2);){
            zos1.setUseZip64(Zip64Mode.Never);
            this.createSecondEntry(zos1).close();
        }
        var6_8 = null;
        try (ZipFile zipFile1 = new ZipFile(file1);
             ZipFile zipFile2 = new ZipFile(file2);){
            File fileResult = File.createTempFile("file-actual.", ".zip", tmp[0]);
            try (ZipArchiveOutputStream zos2 = new ZipArchiveOutputStream(fileResult);){
                zipFile1.copyRawEntries(zos2, this.allFilesPredicate);
                zipFile2.copyRawEntries(zos2, this.allFilesPredicate);
            }
            this.assertSameFileContents(reference, fileResult);
        }
        catch (Throwable throwable) {
            var6_8 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testCopyRawZip64EntryFromFile() throws IOException {
        File[] tmp = this.createTempDirAndFile();
        File reference = File.createTempFile("z64reference.", ".zip", tmp[0]);
        try (ZipArchiveOutputStream zos1 = new ZipArchiveOutputStream(reference);){
            zos1.setUseZip64(Zip64Mode.Always);
            this.createFirstEntry(zos1);
        }
        File file1 = File.createTempFile("zip64src.", ".zip", tmp[0]);
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(file1);){
            zos.setUseZip64(Zip64Mode.Always);
            this.createFirstEntry(zos).close();
        }
        File fileResult = File.createTempFile("file-actual.", ".zip", tmp[0]);
        try (ZipFile zipFile1 = new ZipFile(file1);){
            try (ZipArchiveOutputStream zos2 = new ZipArchiveOutputStream(fileResult);){
                zos2.setUseZip64(Zip64Mode.Always);
                zipFile1.copyRawEntries(zos2, this.allFilesPredicate);
            }
            this.assertSameFileContents(reference, fileResult);
        }
    }

    @Test
    public void testUnixModeInAddRaw() throws IOException {
        File[] tmp = this.createTempDirAndFile();
        File file1 = File.createTempFile("unixModeBits.", ".zip", tmp[0]);
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(file1);){
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry("fred");
            archiveEntry.setUnixMode(436);
            archiveEntry.setMethod(8);
            zos.addRawArchiveEntry(archiveEntry, (InputStream)new ByteArrayInputStream("fud".getBytes()));
        }
        var4_4 = null;
        try (ZipFile zf1 = new ZipFile(file1);){
            ZipArchiveEntry fred = zf1.getEntry("fred");
            Assert.assertEquals((long)436L, (long)fred.getUnixMode());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private File createReferenceFile(File directory, Zip64Mode zipMode, String prefix) throws IOException {
        File reference = File.createTempFile(prefix, ".zip", directory);
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(reference);){
            zos.setUseZip64(zipMode);
            this.createFirstEntry(zos);
            this.createSecondEntry(zos);
        }
        return reference;
    }

    private ZipArchiveOutputStream createFirstEntry(ZipArchiveOutputStream zos) throws IOException {
        this.createArchiveEntry(this.first_payload, zos, "file1.txt");
        return zos;
    }

    private ZipArchiveOutputStream createSecondEntry(ZipArchiveOutputStream zos) throws IOException {
        this.createArchiveEntry(this.second_payload, zos, "file2.txt");
        return zos;
    }

    private void assertSameFileContents(File expectedFile, File actualFile) throws IOException {
        int size = (int)Math.max(expectedFile.length(), actualFile.length());
        try (ZipFile expected = new ZipFile(expectedFile);
             ZipFile actual = new ZipFile(actualFile);){
            byte[] expectedBuf = new byte[size];
            byte[] actualBuf = new byte[size];
            Enumeration actualInOrder = actual.getEntriesInPhysicalOrder();
            Enumeration expectedInOrder = expected.getEntriesInPhysicalOrder();
            while (actualInOrder.hasMoreElements()) {
                ZipArchiveEntry actualElement = (ZipArchiveEntry)actualInOrder.nextElement();
                ZipArchiveEntry expectedElement = (ZipArchiveEntry)expectedInOrder.nextElement();
                Assert.assertEquals((Object)expectedElement.getName(), (Object)actualElement.getName());
                Assert.assertEquals((long)expectedElement.getMethod(), (long)actualElement.getMethod());
                Assert.assertEquals((Object)expectedElement.getGeneralPurposeBit(), (Object)actualElement.getGeneralPurposeBit());
                Assert.assertEquals((long)expectedElement.getCrc(), (long)actualElement.getCrc());
                Assert.assertEquals((long)expectedElement.getCompressedSize(), (long)actualElement.getCompressedSize());
                Assert.assertEquals((long)expectedElement.getSize(), (long)actualElement.getSize());
                Assert.assertEquals((long)expectedElement.getExternalAttributes(), (long)actualElement.getExternalAttributes());
                Assert.assertEquals((long)expectedElement.getInternalAttributes(), (long)actualElement.getInternalAttributes());
                try (InputStream actualIs = actual.getInputStream(actualElement);
                     InputStream expectedIs = expected.getInputStream(expectedElement);){
                    IOUtils.readFully((InputStream)expectedIs, (byte[])expectedBuf);
                    IOUtils.readFully((InputStream)actualIs, (byte[])actualBuf);
                }
                Assert.assertArrayEquals((byte[])expectedBuf, (byte[])actualBuf);
            }
        }
    }

    private void createArchiveEntry(String payload, ZipArchiveOutputStream zos, String name) throws IOException {
        ZipArchiveEntry in = new ZipArchiveEntry(name);
        zos.putArchiveEntry((ArchiveEntry)in);
        zos.write(payload.getBytes());
        zos.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            ZipArchiveEntry in = new ZipArchiveEntry(tmp[1], "foo");
            zos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                zos.write(b);
            }
            fis.close();
            fis = null;
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo");
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assert.assertEquals((long)(tmp[1].lastModified() / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        if (fis != null) {
            fis.close();
        }
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ZipArchiveOutputStream zos = null;
        ZipFile zf = null;
        FileInputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".zip", tmp[0]);
            archive.deleteOnExit();
            zos = new ZipArchiveOutputStream(archive);
            ZipArchiveEntry in = new ZipArchiveEntry("foo");
            in.setTime(tmp[1].lastModified());
            in.setSize(tmp[1].length());
            zos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = new FileInputStream(tmp[1]);
            while (fis.read(b) > 0) {
                zos.write(b);
            }
            fis.close();
            fis = null;
            zos.closeArchiveEntry();
            zos.close();
            zos = null;
            zf = new ZipFile(archive);
            ZipArchiveEntry out = zf.getEntry("foo");
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((Object)"foo", (Object)out.getName());
            Assert.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assert.assertEquals((long)(tmp[1].lastModified() / 2000L), (long)(out.getLastModifiedDate().getTime() / 2000L));
            Assert.assertFalse((boolean)out.isDirectory());
        }
        catch (Throwable throwable) {
            ZipFile.closeQuietly(zf);
            if (zos != null) {
                zos.close();
            }
            ZipTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ZipTestCase.tryHardToDelete(tmp[1]);
            ZipTestCase.rmdir(tmp[0]);
            throw throwable;
        }
        ZipFile.closeQuietly((ZipFile)zf);
        if (zos != null) {
            zos.close();
        }
        ZipTestCase.tryHardToDelete(archive);
        if (fis != null) {
            fis.close();
        }
        ZipTestCase.tryHardToDelete(tmp[1]);
        ZipTestCase.rmdir(tmp[0]);
    }

    @Test
    public void inputStreamStatisticsOfZipBombExcel() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>(){
            {
                this.put("[Content_Types].xml", Arrays.asList(8390036L, 8600L));
                this.put("xl/worksheets/sheet1.xml", Arrays.asList(1348L, 508L));
            }
        };
        this.testInputStreamStatistics("zipbomb.xlsx", (Map<String, List<Long>>)expected);
    }

    @Test
    public void inputStreamStatisticsForImplodedEntry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>(){
            {
                this.put("LICENSE.TXT", Arrays.asList(11560L, 4131L));
            }
        };
        this.testInputStreamStatistics("imploding-8Kdict-3trees.zip", (Map<String, List<Long>>)expected);
    }

    @Test
    public void inputStreamStatisticsForShrunkEntry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>(){
            {
                this.put("TEST1.XML", Arrays.asList(76L, 66L));
                this.put("TEST2.XML", Arrays.asList(81L, 76L));
            }
        };
        this.testInputStreamStatistics("SHRUNK.ZIP", (Map<String, List<Long>>)expected);
    }

    @Test
    public void inputStreamStatisticsForStoredEntry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>(){
            {
                this.put("test.txt", Arrays.asList(5L, 5L));
            }
        };
        this.testInputStreamStatistics("COMPRESS-264.zip", (Map<String, List<Long>>)expected);
    }

    @Test
    public void inputStreamStatisticsForBzip2Entry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>(){
            {
                this.put("lots-of-as", Arrays.asList(42L, 39L));
            }
        };
        this.testInputStreamStatistics("bzip2-zip.zip", (Map<String, List<Long>>)expected);
    }

    @Test
    public void inputStreamStatisticsForDeflate64Entry() throws IOException, ArchiveException {
        HashMap<String, List<Long>> expected = new HashMap<String, List<Long>>(){
            {
                this.put("input2", Arrays.asList(3072L, 2111L));
            }
        };
        this.testInputStreamStatistics("COMPRESS-380/COMPRESS-380.zip", (Map<String, List<Long>>)expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildSplitZipWithTooSmallSizeThrowsException() throws IOException {
        new ZipArchiveOutputStream(File.createTempFile("temp", "zip"), 65535L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void buildSplitZipWithTooLargeSizeThrowsException() throws IOException {
        new ZipArchiveOutputStream(File.createTempFile("temp", "zip"), 0x100000000L);
    }

    @Test(expected=IOException.class)
    public void buildSplitZipWithSegmentAlreadyExistThrowsException() throws IOException {
        File directoryToZip = this.getFilesToZip();
        File outputZipFile = new File(this.dir, "splitZip.zip");
        long splitSize = 102400L;
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(outputZipFile, splitSize);){
            File sameNameFile = new File(this.dir, "splitZip.z01");
            sameNameFile.createNewFile();
            this.addFilesToZip(zipArchiveOutputStream, directoryToZip);
        }
    }

    @Test
    public void buildSplitZipTest() throws IOException {
        File directoryToZip = this.getFilesToZip();
        this.createTestSplitZipSegments();
        File lastFile = new File(this.dir, "splitZip.zip");
        try (SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
             InputStream inputStream = Channels.newInputStream(channel);
             ZipArchiveInputStream splitInputStream = new ZipArchiveInputStream(inputStream, StandardCharsets.UTF_8.toString(), true, false, true);){
            ArchiveEntry entry;
            int filesNum = this.countNonDirectories(directoryToZip);
            int filesCount = 0;
            while ((entry = splitInputStream.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                File fileToCompare = new File(entry.getName());
                try (FileInputStream inputStreamToCompare = new FileInputStream(fileToCompare);){
                    Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)splitInputStream), (byte[])IOUtils.toByteArray((InputStream)inputStreamToCompare));
                }
                ++filesCount;
            }
            Assert.assertEquals((long)filesCount, (long)filesNum);
        }
    }

    private void testInputStreamStatistics(String fileName, Map<String, List<Long>> expectedStatistics) throws IOException, ArchiveException {
        File input = ZipTestCase.getFile(fileName);
        HashMap<String, List<List<Long>>> actualStatistics = new HashMap<String, List<List<Long>>>();
        Throwable throwable = null;
        try (FileInputStream fis = new FileInputStream(input);
             ArchiveInputStream in2 = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)fis);){
            ArchiveEntry entry;
            while ((entry = in2.getNextEntry()) != null) {
                this.readStream((InputStream)in2, entry, actualStatistics);
            }
        }
        catch (Throwable in2) {
            Throwable throwable2 = in2;
            throw in2;
        }
        Throwable throwable3 = null;
        try (ZipFile zf = new ZipFile(input);){
            Enumeration entries = zf.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zae = (ZipArchiveEntry)entries.nextElement();
                InputStream in = zf.getInputStream(zae);
                Throwable throwable4 = null;
                try {
                    this.readStream(in, (ArchiveEntry)zae, actualStatistics);
                }
                catch (Throwable throwable5) {
                    throwable4 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable4 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (Throwable throwable7) {
            Throwable throwable8 = throwable7;
            throw throwable7;
        }
        for (Map.Entry entry : actualStatistics.entrySet()) {
            Assert.assertEquals((String)("Mismatch of stats for: " + (String)entry.getKey()), ((List)entry.getValue()).get(0), ((List)entry.getValue()).get(1));
        }
        for (Map.Entry<Object, Object> entry : expectedStatistics.entrySet()) {
            Assert.assertEquals((String)("Mismatch of stats with expected value for: " + (String)entry.getKey()), (Object)entry.getValue(), ((List)actualStatistics.get(entry.getKey())).get(0));
        }
    }

    private void readStream(InputStream in, ArchiveEntry entry, Map<String, List<List<Long>>> map) throws IOException {
        List<List<Long>> l;
        byte[] buf = new byte[4096];
        InputStreamStatistics stats = (InputStreamStatistics)in;
        while (in.read(buf) != -1) {
        }
        String name = entry.getName();
        if (map.containsKey(name)) {
            l = map.get(name);
        } else {
            l = new ArrayList<List<Long>>();
            map.put(name, l);
        }
        long t = stats.getUncompressedCount();
        long b = stats.getCompressedCount();
        l.add(Arrays.asList(t, b));
    }

    private File getFilesToZip() throws IOException {
        File originalZipFile = ZipTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip.zip");
        try (ZipFile zipFile = new ZipFile(originalZipFile);){
            Enumeration zipEntries = zipFile.getEntries();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                File outputFile = new File(this.dir, zipEntry.getName());
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                outputFile = new File(this.dir, zipEntry.getName());
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    FileOutputStream outputStream = new FileOutputStream(outputFile);
                    Throwable throwable2 = null;
                    try {
                        int readLen;
                        byte[] buffer = new byte[(int)zipEntry.getSize()];
                        while ((readLen = inputStream.read(buffer)) > 0) {
                            ((OutputStream)outputStream).write(buffer, 0, readLen);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)outputStream).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)outputStream).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        return this.dir.listFiles()[0];
    }

    private void createTestSplitZipSegments() throws IOException {
        File directoryToZip = this.getFilesToZip();
        File outputZipFile = new File(this.dir, "splitZip.zip");
        long splitSize = 102400L;
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(outputZipFile, splitSize);){
            this.addFilesToZip(zipArchiveOutputStream, directoryToZip);
        }
    }

    private void addFilesToZip(ZipArchiveOutputStream zipArchiveOutputStream, File fileToAdd) throws IOException {
        if (fileToAdd.isDirectory()) {
            for (File file : fileToAdd.listFiles()) {
                this.addFilesToZip(zipArchiveOutputStream, file);
            }
        } else {
            ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(fileToAdd.getPath());
            zipArchiveEntry.setMethod(8);
            zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
            try (FileInputStream input = new FileInputStream(fileToAdd);){
                IOUtils.copy((InputStream)input, (OutputStream)zipArchiveOutputStream);
            }
            zipArchiveOutputStream.closeArchiveEntry();
        }
    }

    private int countNonDirectories(File file) {
        if (!file.isDirectory()) {
            return 1;
        }
        int result = 0;
        for (File fileInDirectory : file.listFiles()) {
            result += this.countNonDirectories(fileInDirectory);
        }
        return result;
    }
}

