/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ArArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void testReadLongNamesGNU() throws Exception {
        this.checkLongNameEntry("longfile_gnu.ar");
    }

    @Test
    public void testReadLongNamesBSD() throws Exception {
        this.checkLongNameEntry("longfile_bsd.ar");
    }

    private void checkLongNameEntry(String archive) throws Exception {
        try (FileInputStream fis = new FileInputStream(ArArchiveInputStreamTest.getFile(archive));
             ArArchiveInputStream s = new ArArchiveInputStream((InputStream)new BufferedInputStream(fis));){
            ArchiveEntry e = s.getNextEntry();
            Assert.assertEquals((Object)"this_is_a_long_file_name.txt", (Object)e.getName());
            Assert.assertEquals((long)14L, (long)e.getSize());
            byte[] hello = new byte[14];
            s.read(hello);
            Assert.assertEquals((Object)"Hello, world!\n", (Object)ArchiveUtils.toAsciiString((byte[])hello));
            e = s.getNextEntry();
            Assert.assertEquals((Object)"this_is_a_long_file_name_as_well.txt", (Object)e.getName());
            Assert.assertEquals((long)4L, (long)e.getSize());
            byte[] bye = new byte[4];
            s.read(bye);
            Assert.assertEquals((Object)"Bye\n", (Object)ArchiveUtils.toAsciiString((byte[])bye));
            Assert.assertNull((Object)s.getNextEntry());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (FileInputStream in = new FileInputStream(ArArchiveInputStreamTest.getFile("bla.ar"));
             ArArchiveInputStream archive = new ArArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (FileInputStream in = new FileInputStream(ArArchiveInputStreamTest.getFile("bla.ar"));
             ArArchiveInputStream archive = new ArArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }

    @Test
    public void simpleInputStream() throws IOException {
        try (final FileInputStream fileInputStream = new FileInputStream(ArArchiveInputStreamTest.getFile("bla.ar"));){
            InputStream simpleInputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return fileInputStream.read();
                }
            };
            try (ArArchiveInputStream archiveInputStream = new ArArchiveInputStream(simpleInputStream);){
                ArArchiveEntry entry1 = archiveInputStream.getNextArEntry();
                Assert.assertThat((Object)entry1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
                Assert.assertThat((Object)entry1.getName(), (Matcher)CoreMatchers.equalTo((Object)"test1.xml"));
                Assert.assertThat((Object)entry1.getLength(), (Matcher)CoreMatchers.equalTo((Object)610L));
                ArArchiveEntry entry2 = archiveInputStream.getNextArEntry();
                Assert.assertThat((Object)entry2.getName(), (Matcher)CoreMatchers.equalTo((Object)"test2.xml"));
                Assert.assertThat((Object)entry2.getLength(), (Matcher)CoreMatchers.equalTo((Object)82L));
                Assert.assertThat((Object)archiveInputStream.getNextArEntry(), (Matcher)CoreMatchers.nullValue());
            }
        }
    }

    @Test(expected=IllegalStateException.class)
    public void cantReadWithoutOpeningAnEntry() throws Exception {
        try (FileInputStream in = new FileInputStream(ArArchiveInputStreamTest.getFile("bla.ar"));
             ArArchiveInputStream archive = new ArArchiveInputStream((InputStream)in);){
            archive.read();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void cantReadAfterClose() throws Exception {
        try (FileInputStream in = new FileInputStream(ArArchiveInputStreamTest.getFile("bla.ar"));
             ArArchiveInputStream archive = new ArArchiveInputStream((InputStream)in);){
            archive.close();
            archive.read();
        }
    }
}

