/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.arj;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.arj.ArjArchiveEntry;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArjArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void testArjUnarchive() throws Exception {
        StringBuilder expected = new StringBuilder();
        expected.append("test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        StringBuilder result = new StringBuilder();
        try (ArjArchiveInputStream in = new ArjArchiveInputStream((InputStream)new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.arj")));){
            ArjArchiveEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                int tmp;
                result.append(entry.getName());
                while ((tmp = in.read()) != -1) {
                    result.append((char)tmp);
                }
                Assert.assertFalse((boolean)entry.isDirectory());
            }
        }
        Assert.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testReadingOfAttributesDosVersion() throws Exception {
        try (ArjArchiveInputStream in = new ArjArchiveInputStream((InputStream)new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.arj")));){
            ArjArchiveEntry entry = in.getNextEntry();
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
            Assert.assertEquals((long)30L, (long)entry.getSize());
            Assert.assertEquals((long)0L, (long)entry.getUnixMode());
            Calendar cal = Calendar.getInstance();
            cal.set(2008, 9, 6, 23, 50, 52);
            cal.set(14, 0);
            Assert.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
        }
    }

    @Test
    public void testReadingOfAttributesUnixVersion() throws Exception {
        try (ArjArchiveInputStream in = new ArjArchiveInputStream((InputStream)new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.unix.arj")));){
            ArjArchiveEntry entry = in.getNextEntry();
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
            Assert.assertEquals((long)30L, (long)entry.getSize());
            Assert.assertEquals((long)436L, (long)(entry.getUnixMode() & 0xFFF));
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0000"));
            cal.set(2008, 9, 6, 21, 50, 52);
            cal.set(14, 0);
            Assert.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (FileInputStream in = new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.arj"));
             ArjArchiveInputStream archive = new ArjArchiveInputStream((InputStream)in);){
            ArjArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (FileInputStream in = new FileInputStream(ArjArchiveInputStreamTest.getFile("bla.arj"));
             ArjArchiveInputStream archive = new ArjArchiveInputStream((InputStream)in);){
            ArjArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }
}

