/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class SparseFilesTest
extends AbstractTestCase {
    private final boolean isOnWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOldGNU() throws Throwable {
        File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
        try (TarArchiveInputStream tin = null;){
            tin = new TarArchiveInputStream((InputStream)new FileInputStream(file));
            TarArchiveEntry ae = tin.getNextTarEntry();
            Assert.assertEquals((Object)"sparsefile", (Object)ae.getName());
            Assert.assertTrue((boolean)ae.isOldGNUSparse());
            Assert.assertTrue((boolean)ae.isGNUSparse());
            Assert.assertFalse((boolean)ae.isPaxGNUSparse());
            Assert.assertFalse((boolean)tin.canReadEntryData((ArchiveEntry)ae));
            List sparseHeaders = ae.getSparseHeaders();
            Assert.assertEquals((long)3L, (long)sparseHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
        }
    }

    @Test
    public void testPaxGNU() throws Throwable {
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream tin = null;){
            tin = new TarArchiveInputStream((InputStream)new FileInputStream(file));
            this.assertPaxGNUEntry(tin, "0.0");
            this.assertPaxGNUEntry(tin, "0.1");
            this.assertPaxGNUEntry(tin, "1.0");
        }
    }

    @Test
    public void testExtractSparseTarsOnWindows() throws IOException {
        if (!this.isOnWindows) {
            return;
        }
        File oldGNUSparseTar = SparseFilesTest.getFile("oldgnu_sparse.tar");
        File paxGNUSparseTar = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream paxGNUSparseInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(paxGNUSparseTar));){
            paxGNUSparseInputStream.getNextTarEntry();
            try (TarArchiveInputStream oldGNUSparseInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(oldGNUSparseTar));){
                oldGNUSparseInputStream.getNextTarEntry();
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            paxGNUSparseInputStream.getNextTarEntry();
            oldGNUSparseInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(oldGNUSparseTar));
            var6_8 = null;
            try {
                oldGNUSparseInputStream.getNextTarEntry();
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (oldGNUSparseInputStream != null) {
                    if (var6_8 != null) {
                        try {
                            oldGNUSparseInputStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        oldGNUSparseInputStream.close();
                    }
                }
            }
            paxGNUSparseInputStream.getNextTarEntry();
            oldGNUSparseInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(oldGNUSparseTar));
            var6_8 = null;
            try {
                oldGNUSparseInputStream.getNextTarEntry();
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (oldGNUSparseInputStream != null) {
                    if (var6_8 != null) {
                        try {
                            oldGNUSparseInputStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        oldGNUSparseInputStream.close();
                    }
                }
            }
        }
    }

    @Test
    public void testExtractOldGNU() throws IOException, InterruptedException {
        if (this.isOnWindows) {
            return;
        }
        try {
            File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile");
                 TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new FileInputStream(file));){
                tin.getNextTarEntry();
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
        }
        catch (IOException | RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @Test
    public void testExtractExtendedOldGNU() throws IOException, InterruptedException {
        if (this.isOnWindows) {
            return;
        }
        File file = SparseFilesTest.getFile("oldgnu_extended_sparse.tar");
        try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparse6");
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new FileInputStream(file));){
            TarArchiveEntry ae = tin.getNextTarEntry();
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            List sparseHeaders = ae.getSparseHeaders();
            Assert.assertEquals((long)7L, (long)sparseHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)10240L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)16384L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assert.assertEquals((long)24576L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            Assert.assertEquals((long)29696L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getNumbytes());
            Assert.assertEquals((long)36864L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getNumbytes());
            Assert.assertEquals((long)51200L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getNumbytes());
        }
    }

    @Test
    public void testExtractPaxGNU() throws IOException, InterruptedException {
        if (this.isOnWindows) {
            return;
        }
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)new FileInputStream(file));){
            tin.getNextTarEntry();
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.0");){
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            tin.getNextTarEntry();
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.0");
            var5_7 = null;
            try {
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (sparseFileInputStream != null) {
                    if (var5_7 != null) {
                        try {
                            sparseFileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        sparseFileInputStream.close();
                    }
                }
            }
            tin.getNextTarEntry();
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-1.0");
            var5_7 = null;
            try {
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (sparseFileInputStream != null) {
                    if (var5_7 != null) {
                        try {
                            sparseFileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        sparseFileInputStream.close();
                    }
                }
            }
        }
    }

    private void assertPaxGNUEntry(TarArchiveInputStream tin, String suffix) throws Throwable {
        TarArchiveEntry ae = tin.getNextTarEntry();
        Assert.assertEquals((Object)("sparsefile-" + suffix), (Object)ae.getName());
        Assert.assertTrue((boolean)ae.isGNUSparse());
        Assert.assertTrue((boolean)ae.isPaxGNUSparse());
        Assert.assertFalse((boolean)ae.isOldGNUSparse());
        Assert.assertFalse((boolean)tin.canReadEntryData((ArchiveEntry)ae));
        List sparseHeaders = ae.getSparseHeaders();
        Assert.assertEquals((long)3L, (long)sparseHeaders.size());
        Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
        Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
        Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
        Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
        Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
        Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
    }

    private InputStream extractTarAndGetInputStream(File tarFile, String sparseFileName) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("tar", "-xf", tarFile.getPath(), "-C", this.resultDir.getPath());
        pb.redirectErrorStream(true);
        Process process = pb.start();
        Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)process.getInputStream())), (long)0L, (long)process.waitFor());
        for (File file : this.resultDir.listFiles()) {
            if (!file.getName().equals(sparseFileName)) continue;
            return new FileInputStream(file);
        }
        Assert.fail((String)("didn't find " + sparseFileName + " after extracting " + tarFile));
        return null;
    }
}

