/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequestSupplier;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ParallelScatterZipCreatorTest {
    private final int NUMITEMS = 5000;
    private File result;
    private File tmp;

    @After
    public void cleanup() {
        AbstractTestCase.tryHardToDelete(this.result);
        AbstractTestCase.tryHardToDelete(this.tmp);
    }

    @Test
    public void concurrent() throws Exception {
        this.result = File.createTempFile("parallelScatterGather1", "");
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(this.result);
        zos.setEncoding("UTF-8");
        ParallelScatterZipCreator zipCreator = new ParallelScatterZipCreator();
        Map<String, byte[]> entries = this.writeEntries(zipCreator);
        zipCreator.writeTo(zos);
        zos.close();
        this.removeEntriesFoundInZipFile(this.result, entries);
        Assert.assertTrue((entries.size() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)zipCreator.getStatisticsMessage());
    }

    @Test
    public void callableApiUsingSubmit() throws Exception {
        this.result = File.createTempFile("parallelScatterGather2", "");
        this.callableApi(new CallableConsumerSupplier(){

            @Override
            public CallableConsumer apply(final ParallelScatterZipCreator zipCreator) {
                return new CallableConsumer(){

                    @Override
                    public void accept(Callable<? extends ScatterZipOutputStream> c) {
                        zipCreator.submit(c);
                    }
                };
            }
        });
    }

    @Test
    public void callableApiUsingSubmitStreamAwareCallable() throws Exception {
        this.result = File.createTempFile("parallelScatterGather3", "");
        this.callableApi(new CallableConsumerSupplier(){

            @Override
            public CallableConsumer apply(final ParallelScatterZipCreator zipCreator) {
                return new CallableConsumer(){

                    @Override
                    public void accept(Callable<? extends ScatterZipOutputStream> c) {
                        zipCreator.submitStreamAwareCallable(c);
                    }
                };
            }
        });
    }

    private void callableApi(CallableConsumerSupplier consumerSupplier) throws Exception {
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream(this.result);
        zos.setEncoding("UTF-8");
        ExecutorService es = Executors.newFixedThreadPool(1);
        ScatterGatherBackingStoreSupplier supp = new ScatterGatherBackingStoreSupplier(){

            public ScatterGatherBackingStore get() throws IOException {
                return new FileBasedScatterGatherBackingStore(ParallelScatterZipCreatorTest.this.tmp = File.createTempFile("parallelscatter", "n1"));
            }
        };
        ParallelScatterZipCreator zipCreator = new ParallelScatterZipCreator(es, supp);
        Map<String, byte[]> entries = this.writeEntriesAsCallable(zipCreator, consumerSupplier.apply(zipCreator));
        zipCreator.writeTo(zos);
        zos.close();
        this.removeEntriesFoundInZipFile(this.result, entries);
        Assert.assertTrue((entries.size() == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)zipCreator.getStatisticsMessage());
    }

    private void removeEntriesFoundInZipFile(File result, Map<String, byte[]> entries) throws IOException {
        ZipFile zf = new ZipFile(result);
        Enumeration entriesInPhysicalOrder = zf.getEntriesInPhysicalOrder();
        int i = 0;
        while (entriesInPhysicalOrder.hasMoreElements()) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entriesInPhysicalOrder.nextElement();
            InputStream inputStream = zf.getInputStream(zipArchiveEntry);
            byte[] actual = IOUtils.toByteArray((InputStream)inputStream);
            byte[] expected = entries.remove(zipArchiveEntry.getName());
            Assert.assertArrayEquals((String)("For " + zipArchiveEntry.getName()), (byte[])expected, (byte[])actual);
            Assert.assertEquals((String)("For " + zipArchiveEntry.getName()), (Object)("file" + i++), (Object)zipArchiveEntry.getName());
        }
        zf.close();
    }

    private Map<String, byte[]> writeEntries(ParallelScatterZipCreator zipCreator) {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        for (int i = 0; i < 5000; ++i) {
            final byte[] payloadBytes = ("content" + i).getBytes();
            final ZipArchiveEntry za = this.createZipArchiveEntry(entries, i, payloadBytes);
            final InputStreamSupplier iss = new InputStreamSupplier(){

                public InputStream get() {
                    return new ByteArrayInputStream(payloadBytes);
                }
            };
            if (i % 2 == 0) {
                zipCreator.addArchiveEntry(za, iss);
                continue;
            }
            ZipArchiveEntryRequestSupplier zaSupplier = new ZipArchiveEntryRequestSupplier(){

                public ZipArchiveEntryRequest get() {
                    return ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)za, (InputStreamSupplier)iss);
                }
            };
            zipCreator.addArchiveEntry(zaSupplier);
        }
        return entries;
    }

    private Map<String, byte[]> writeEntriesAsCallable(ParallelScatterZipCreator zipCreator, CallableConsumer consumer) {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        for (int i = 0; i < 5000; ++i) {
            Callable callable;
            final byte[] payloadBytes = ("content" + i).getBytes();
            final ZipArchiveEntry za = this.createZipArchiveEntry(entries, i, payloadBytes);
            final InputStreamSupplier iss = new InputStreamSupplier(){

                public InputStream get() {
                    return new ByteArrayInputStream(payloadBytes);
                }
            };
            if (i % 2 == 0) {
                callable = zipCreator.createCallable(za, iss);
            } else {
                ZipArchiveEntryRequestSupplier zaSupplier = new ZipArchiveEntryRequestSupplier(){

                    public ZipArchiveEntryRequest get() {
                        return ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)za, (InputStreamSupplier)iss);
                    }
                };
                callable = zipCreator.createCallable(zaSupplier);
            }
            consumer.accept(callable);
        }
        return entries;
    }

    private ZipArchiveEntry createZipArchiveEntry(Map<String, byte[]> entries, int i, byte[] payloadBytes) {
        ZipArchiveEntry za = new ZipArchiveEntry("file" + i);
        entries.put(za.getName(), payloadBytes);
        za.setMethod(8);
        za.setSize((long)payloadBytes.length);
        za.setUnixMode(33204);
        return za;
    }

    private static interface CallableConsumerSupplier {
        public CallableConsumer apply(ParallelScatterZipCreator var1);
    }

    private static interface CallableConsumer {
        public void accept(Callable<? extends ScatterZipOutputStream> var1);
    }
}

