/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.junit.Assert;
import org.junit.Test;

public class ZipEightByteIntegerTest {
    @Test
    public void testLongToBytes() {
        ZipEightByteInteger zl = new ZipEightByteInteger(734744827512L);
        byte[] result = zl.getBytes();
        Assert.assertEquals((String)"length getBytes", (long)8L, (long)result.length);
        Assert.assertEquals((String)"first byte getBytes", (long)120L, (long)result[0]);
        Assert.assertEquals((String)"second byte getBytes", (long)86L, (long)result[1]);
        Assert.assertEquals((String)"third byte getBytes", (long)52L, (long)result[2]);
        Assert.assertEquals((String)"fourth byte getBytes", (long)18L, (long)result[3]);
        Assert.assertEquals((String)"fifth byte getBytes", (long)-85L, (long)result[4]);
        Assert.assertEquals((String)"sixth byte getBytes", (long)0L, (long)result[5]);
        Assert.assertEquals((String)"seventh byte getBytes", (long)0L, (long)result[6]);
        Assert.assertEquals((String)"eighth byte getBytes", (long)0L, (long)result[7]);
    }

    @Test
    public void testLongFromBytes() {
        byte[] val = new byte[]{120, 86, 52, 18, -85, 0, 0, 0};
        ZipEightByteInteger zl = new ZipEightByteInteger(val);
        Assert.assertEquals((String)"longValue from bytes", (long)734744827512L, (long)zl.getLongValue());
    }

    @Test
    public void testBIToBytes() {
        ZipEightByteInteger zl = new ZipEightByteInteger(BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1));
        byte[] result = zl.getBytes();
        Assert.assertEquals((String)"length getBytes", (long)8L, (long)result.length);
        Assert.assertEquals((String)"first byte getBytes", (long)-2L, (long)result[0]);
        Assert.assertEquals((String)"second byte getBytes", (long)-1L, (long)result[1]);
        Assert.assertEquals((String)"third byte getBytes", (long)-1L, (long)result[2]);
        Assert.assertEquals((String)"fourth byte getBytes", (long)-1L, (long)result[3]);
        Assert.assertEquals((String)"fifth byte getBytes", (long)-1L, (long)result[4]);
        Assert.assertEquals((String)"sixth byte getBytes", (long)-1L, (long)result[5]);
        Assert.assertEquals((String)"seventh byte getBytes", (long)-1L, (long)result[6]);
        Assert.assertEquals((String)"eighth byte getBytes", (long)-1L, (long)result[7]);
    }

    @Test
    public void testBIFromBytes() {
        byte[] val = new byte[]{-2, -1, -1, -1, -1, -1, -1, -1};
        ZipEightByteInteger zl = new ZipEightByteInteger(val);
        Assert.assertEquals((String)"value from bytes", (Object)BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1), (Object)zl.getValue());
    }

    @Test
    public void testEquals() {
        ZipEightByteInteger zl = new ZipEightByteInteger(305419896L);
        ZipEightByteInteger zl2 = new ZipEightByteInteger(305419896L);
        ZipEightByteInteger zl3 = new ZipEightByteInteger(-2023406815L);
        Assert.assertTrue((String)"reflexive", (boolean)zl.equals((Object)zl));
        Assert.assertTrue((String)"works", (boolean)zl.equals((Object)zl2));
        Assert.assertTrue((String)"works, part two", (!zl.equals((Object)zl3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"symmetric", (boolean)zl2.equals((Object)zl));
        Assert.assertTrue((String)"null handling", (!zl.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"non ZipEightByteInteger handling", (!zl.equals((Object)new Integer(4660)) ? 1 : 0) != 0);
    }

    @Test
    public void testSign() {
        ZipEightByteInteger zl = new ZipEightByteInteger(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        Assert.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).setBit(0), (Object)zl.getValue());
    }
}

