/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipSplitOutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZipSplitOutputStreamTest
extends AbstractTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void throwsExceptionIfSplitSizeIsTooSmall() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 65535L);
    }

    @Test
    public void throwsExceptionIfSplitSizeIsTooLarge() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 0x100000000L);
    }

    @Test
    public void throwsIfUnsplittableSizeLargerThanSplitSize() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        long splitSize = 102400L;
        ZipSplitOutputStream output = new ZipSplitOutputStream(File.createTempFile("temp", "zip"), splitSize);
        output.prepareToWriteUnsplittableContent(splitSize + 1L);
    }

    @Test
    public void splitZipBeginsWithZipSplitSignature() throws IOException {
        File tempFile = File.createTempFile("temp", "zip");
        new ZipSplitOutputStream(tempFile, 102400L);
        FileInputStream inputStream = new FileInputStream(tempFile);
        byte[] buffer = new byte[4];
        ((InputStream)inputStream).read(buffer);
        Assert.assertEquals((long)ByteBuffer.wrap(ZipArchiveOutputStream.DD_SIG).getInt(), (long)ByteBuffer.wrap(buffer).getInt());
    }

    @Test
    public void testCreateSplittedFiles() throws IOException {
        int readLen;
        File testOutputFile = new File(this.dir, "testCreateSplittedFiles.zip");
        int splitSize = 102400;
        ZipSplitOutputStream zipSplitOutputStream = new ZipSplitOutputStream(testOutputFile, (long)splitSize);
        File fileToTest = ZipSplitOutputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip.zip");
        FileInputStream inputStream = new FileInputStream(fileToTest);
        byte[] buffer = new byte[4096];
        while ((readLen = ((InputStream)inputStream).read(buffer)) > 0) {
            zipSplitOutputStream.write(buffer, 0, readLen);
        }
        ((InputStream)inputStream).close();
        zipSplitOutputStream.close();
        File zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z01");
        Assert.assertEquals((long)zipFile.length(), (long)splitSize);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z02");
        Assert.assertEquals((long)zipFile.length(), (long)splitSize);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z03");
        Assert.assertEquals((long)zipFile.length(), (long)splitSize);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z04");
        Assert.assertEquals((long)zipFile.length(), (long)splitSize);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z05");
        Assert.assertEquals((long)zipFile.length(), (long)splitSize);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.zip");
        Assert.assertEquals((long)zipFile.length(), (long)(fileToTest.length() + 4L - (long)(splitSize * 5)));
    }
}

