/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class BZip2TestCase
extends AbstractTestCase {
    @Test
    public void testBzipCreation() throws Exception {
        File output = null;
        File input = BZip2TestCase.getFile("test.txt");
        output = new File(this.dir, "test.txt.bz2");
        FileOutputStream out = new FileOutputStream(output);
        CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("bzip2", (OutputStream)out);
        FileInputStream in = new FileInputStream(input);
        IOUtils.copy((InputStream)in, (OutputStream)cos);
        cos.close();
        in.close();
        File decompressed = new File(this.dir, "decompressed.txt");
        File toDecompress = output;
        FileInputStream is = new FileInputStream(toDecompress);
        CompressorInputStream in2 = new CompressorStreamFactory().createCompressorInputStream("bzip2", (InputStream)is);
        FileOutputStream os = new FileOutputStream(decompressed);
        IOUtils.copy((InputStream)in2, (OutputStream)os);
        ((InputStream)is).close();
        os.close();
        Assert.assertEquals((long)input.length(), (long)decompressed.length());
    }

    @Test
    public void testBzip2Unarchive() throws Exception {
        File input = BZip2TestCase.getFile("bla.txt.bz2");
        File output = new File(this.dir, "bla.txt");
        FileInputStream is = new FileInputStream(input);
        CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("bzip2", (InputStream)is);
        FileOutputStream os = new FileOutputStream(output);
        IOUtils.copy((InputStream)in, (OutputStream)os);
        ((InputStream)is).close();
        os.close();
    }

    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = BZip2TestCase.getFile("multiple.bz2");
        try (FileInputStream is = new FileInputStream(input);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("bzip2", (InputStream)is);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    @Test
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = BZip2TestCase.getFile("multiple.bz2");
        try (FileInputStream is = new FileInputStream(input);
             BZip2CompressorInputStream in = new BZip2CompressorInputStream((InputStream)is, true);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)98L, (long)in.read());
            Assert.assertEquals((long)0L, (long)in.available());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    @Test
    public void testCOMPRESS131() throws Exception {
        File input = BZip2TestCase.getFile("COMPRESS-131.bz2");
        try (FileInputStream is = new FileInputStream(input);
             BZip2CompressorInputStream in = new BZip2CompressorInputStream((InputStream)is, true);){
            int l = 0;
            while (in.read() != -1) {
                ++l;
            }
            Assert.assertEquals((long)539L, (long)l);
        }
    }
}

