/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.lz77support.AbstractLZ77CompressorInputStream;
import org.junit.Assert;
import org.junit.Test;

public class AbstractLZ77CompressorInputStreamTest {
    @Test(expected=IllegalStateException.class)
    public void cantPrefillAfterDataHasBeenRead() throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4};
        try (TestStream s = new TestStream(new ByteArrayInputStream(data));){
            s.literal(3);
            Assert.assertEquals((long)1L, (long)s.read());
            s.prefill(new byte[]{1, 2, 3});
        }
    }

    @Test
    public void prefillCanBeUsedForBackReferences() throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4};
        try (TestStream s = new TestStream(new ByteArrayInputStream(new byte[0]));){
            s.prefill(data);
            s.startBackReference(2, 4L);
            byte[] r = new byte[4];
            Assert.assertEquals((long)4L, (long)s.read(r));
            Assert.assertArrayEquals((byte[])new byte[]{3, 4, 3, 4}, (byte[])r);
        }
    }

    @Test
    public void ifPrefillExceedsWindowSizeTheLastBytesAreUsed() throws IOException {
        byte[] data = new byte[2048];
        data[2046] = 3;
        data[2047] = 4;
        try (TestStream s = new TestStream(new ByteArrayInputStream(new byte[0]));){
            s.prefill(data);
            s.startBackReference(2, 4L);
            byte[] r = new byte[4];
            Assert.assertEquals((long)4L, (long)s.read(r));
            Assert.assertArrayEquals((byte[])new byte[]{3, 4, 3, 4}, (byte[])r);
        }
    }

    private static class TestStream
    extends AbstractLZ77CompressorInputStream {
        private boolean literal;

        TestStream(InputStream in) throws IOException {
            super(in, 1024);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.literal) {
                return this.readLiteral(b, off, len);
            }
            return this.readBackReference(b, off, len);
        }

        void literal(int len) {
            this.startLiteral(len);
            this.literal = true;
        }
    }
}

