/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZstdCompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void testZstdDecode() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File expected = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        try (FileInputStream inputStream = new FileInputStream(input);
             ZstdCompressorInputStream zstdInputStream = new ZstdCompressorInputStream((InputStream)inputStream);){
            byte[] b = new byte[97];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = zstdInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assert.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testCachingIsEnabledByDefaultAndZstdUtilsPresent() {
        Assert.assertEquals((Object)ZstdUtils.CachedAvailability.CACHED_AVAILABLE, (Object)ZstdUtils.getCachedZstdAvailability());
        Assert.assertTrue((boolean)ZstdUtils.isZstdCompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            ZstdUtils.setCacheZstdAvailablity((boolean)false);
            Assert.assertEquals((Object)ZstdUtils.CachedAvailability.DONT_CACHE, (Object)ZstdUtils.getCachedZstdAvailability());
            Assert.assertTrue((boolean)ZstdUtils.isZstdCompressionAvailable());
        }
        finally {
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
        }
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            ZstdUtils.setCacheZstdAvailablity((boolean)false);
            Assert.assertEquals((Object)ZstdUtils.CachedAvailability.DONT_CACHE, (Object)ZstdUtils.getCachedZstdAvailability());
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
            Assert.assertEquals((Object)ZstdUtils.CachedAvailability.CACHED_AVAILABLE, (Object)ZstdUtils.getCachedZstdAvailability());
        }
        finally {
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
        }
    }

    @Test
    public void shouldBeAbleToSkipAByte() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        try (FileInputStream is = new FileInputStream(input);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream((InputStream)is);
            Assert.assertEquals((long)1L, (long)in.skip(1L));
            in.close();
        }
    }

    @Test
    public void singleByteReadWorksAsExpected() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File original = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        long originalFileLength = original.length();
        byte[] originalFileContent = new byte[(int)originalFileLength];
        try (FileInputStream ois = new FileInputStream(original);){
            ((InputStream)ois).read(originalFileContent);
        }
        var7_6 = null;
        try (FileInputStream is = new FileInputStream(input);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream((InputStream)is);
            Assert.assertEquals((long)originalFileContent[0], (long)in.read());
            in.close();
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        try (FileInputStream is = new FileInputStream(input);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        byte[] buf = new byte[2];
        try (FileInputStream is = new FileInputStream(input);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZstandardUnarchive() throws Exception {
        File input = ZstdCompressorInputStreamTest.getFile("bla.tar.zst");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("zstd", (InputStream)is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
    }
}

