/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipSplitReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZipSplitReadOnlySeekableByteChannelTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void constructorThrowsOnNullArg() throws IOException {
        this.thrown.expect(NullPointerException.class);
        new ZipSplitReadOnlySeekableByteChannel(null);
    }

    @Test
    public void constructorThrowsOnNonSplitZipFiles() throws IOException {
        this.thrown.expect(IOException.class);
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        File file = AbstractTestCase.getFile("COMPRESS-189.zip");
        channels.add(Files.newByteChannel(file.toPath(), StandardOpenOption.READ));
        new ZipSplitReadOnlySeekableByteChannel(channels);
    }

    @Test
    public void channelsPositionIsZeroAfterConstructor() throws IOException {
        List<SeekableByteChannel> channels = this.getSplitZipChannels();
        new ZipSplitReadOnlySeekableByteChannel(channels);
        for (SeekableByteChannel channel : channels) {
            Assert.assertEquals((long)0L, (long)channel.position());
        }
    }

    @Test
    public void forOrderedSeekableByteChannelsThrowsOnNullArg() throws IOException {
        this.thrown.expect(NullPointerException.class);
        ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels(null);
    }

    @Test
    public void forOrderedSeekableByteChannelsOfTwoParametersThrowsOnNullArg() throws IOException {
        this.thrown.expect(NullPointerException.class);
        ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels(null, null);
    }

    @Test
    public void forOrderedSeekableByteChannelsReturnCorrectClass() throws IOException {
        File file1 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        SeekableByteChannel firstChannel = Files.newByteChannel(file1.toPath(), StandardOpenOption.READ);
        File file2 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        SeekableByteChannel secondChannel = Files.newByteChannel(file2.toPath(), StandardOpenOption.READ);
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        SeekableByteChannel lastChannel = Files.newByteChannel(lastFile.toPath(), StandardOpenOption.READ);
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        channels.add(firstChannel);
        channels.add(secondChannel);
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel)lastChannel, channels);
        Assert.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
        channel = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{firstChannel, secondChannel, lastChannel});
        Assert.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
    }

    @Test
    public void forOrderedSeekableByteChannelsReturnsIdentityForSingleElement() throws IOException {
        SeekableInMemoryByteChannel emptyChannel = new SeekableInMemoryByteChannel(new byte[0]);
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forOrderedSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{emptyChannel});
        Assert.assertSame((Object)emptyChannel, (Object)channel);
    }

    @Test
    public void forFilesThrowsOnNullArg() throws IOException {
        this.thrown.expect(NullPointerException.class);
        ZipSplitReadOnlySeekableByteChannel.forFiles(null);
    }

    @Test
    public void forFilesOfTwoParametersThrowsOnNullArg() throws IOException {
        this.thrown.expect(NullPointerException.class);
        ZipSplitReadOnlySeekableByteChannel.forFiles(null, null);
    }

    @Test
    public void forFilesReturnCorrectClass() throws IOException {
        File firstFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        File secondFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        ArrayList<File> list = new ArrayList<File>();
        list.add(firstFile);
        list.add(secondFile);
        SeekableByteChannel channel = ZipSplitReadOnlySeekableByteChannel.forFiles((File)lastFile, list);
        Assert.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
        channel = ZipSplitReadOnlySeekableByteChannel.forFiles((File[])new File[]{firstFile, secondFile, lastFile});
        Assert.assertTrue((boolean)(channel instanceof ZipSplitReadOnlySeekableByteChannel));
    }

    @Test
    public void buildFromLastSplitSegmentThrowsOnNotZipFile() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
    }

    @Test
    public void positionToSomeZipSplitSegment() throws IOException {
        File firstFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        int firstFileSize = (int)firstFile.length();
        File secondFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        int secondFileSize = (int)secondFile.length();
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        int lastFileSize = (int)lastFile.length();
        Random random = new Random();
        int randomDiskNumber = random.nextInt(3);
        int randomOffset = randomDiskNumber < 2 ? random.nextInt(firstFileSize) : random.nextInt(lastFileSize);
        ZipSplitReadOnlySeekableByteChannel channel = (ZipSplitReadOnlySeekableByteChannel)ZipSplitReadOnlySeekableByteChannel.buildFromLastSplitSegment((File)lastFile);
        channel.position((long)randomDiskNumber, (long)randomOffset);
        long expectedPosition = randomOffset;
        expectedPosition += randomDiskNumber > 0 ? (long)firstFileSize : 0L;
        Assert.assertEquals((long)(expectedPosition += randomDiskNumber > 1 ? (long)secondFileSize : 0L), (long)channel.position());
    }

    private List<SeekableByteChannel> getSplitZipChannels() throws IOException {
        ArrayList<SeekableByteChannel> channels = new ArrayList<SeekableByteChannel>();
        File file1 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z01");
        channels.add(Files.newByteChannel(file1.toPath(), StandardOpenOption.READ));
        File file2 = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.z02");
        channels.add(Files.newByteChannel(file2.toPath(), StandardOpenOption.READ));
        File lastFile = AbstractTestCase.getFile("COMPRESS-477/split_zip_created_by_zip/split_zip_created_by_zip.zip");
        channels.add(Files.newByteChannel(lastFile.toPath(), StandardOpenOption.READ));
        return channels;
    }
}

