/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.junit.Assert;
import org.junit.Test;

public class ChainingTestCase
extends AbstractTestCase {
    @Test
    public void testTarGzip() throws Exception {
        File file = ChainingTestCase.getFile("bla.tgz");
        try (TarArchiveInputStream is = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));){
            TarArchiveEntry entry = (TarArchiveEntry)is.getNextEntry();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
        }
    }

    @Test
    public void testTarBzip2() throws Exception {
        File file = ChainingTestCase.getFile("bla.tar.bz2");
        try (TarArchiveInputStream is = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));){
            TarArchiveEntry entry = (TarArchiveEntry)is.getNextEntry();
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
        }
    }
}

