/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.examples.Expander;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedExpanderTest
extends AbstractTestCase {
    private final String format;
    private File archive;

    @Parameterized.Parameters(name="format={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"tar"}, {"cpio"}, {"zip"});
    }

    public ParameterizedExpanderTest(String format) {
        this.format = format;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.archive = new File(this.dir, "test." + this.format);
        File dummy = new File(this.dir, "x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        var3_3 = null;
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream(this.format, Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir.toPath(), "a", new LinkOption[0]));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.dir, "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void fileVersion() throws IOException, ArchiveException {
        new Expander().expand(this.format, this.archive, this.resultDir);
        this.verifyTargetDir();
    }

    @Test
    public void fileVersionWithAutoDetection() throws IOException, ArchiveException {
        new Expander().expand(this.archive, this.resultDir);
        this.verifyTargetDir();
    }

    @Test
    public void inputStreamVersion() throws IOException, ArchiveException {
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            new Expander().expand(this.format, (InputStream)i, this.resultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void inputStreamVersionWithAutoDetection() throws IOException, ArchiveException {
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            new Expander().expand((InputStream)i, this.resultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void channelVersion() throws IOException, ArchiveException {
        try (FileChannel c = FileChannel.open(this.archive.toPath(), StandardOpenOption.READ);){
            new Expander().expand(this.format, (SeekableByteChannel)c, this.resultDir);
        }
        this.verifyTargetDir();
    }

    @Test
    public void archiveInputStreamVersion() throws IOException, ArchiveException {
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));
             ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream(this.format, (InputStream)i);){
            new Expander().expand(ais, this.resultDir);
        }
        this.verifyTargetDir();
    }

    private void verifyTargetDir() throws IOException {
        Assert.assertTrue((String)"a has not been created", (boolean)new File(this.resultDir, "a").isDirectory());
        Assert.assertTrue((String)"a/b has not been created", (boolean)new File(this.resultDir, "a/b").isDirectory());
        Assert.assertTrue((String)"a/b/c has not been created", (boolean)new File(this.resultDir, "a/b/c").isDirectory());
        this.assertHelloWorld("a/b/d.txt", "1");
        this.assertHelloWorld("a/b/c/e.txt", "2");
    }

    private void assertHelloWorld(String fileName, String suffix) throws IOException {
        Assert.assertTrue((String)(fileName + " does not exist"), (boolean)new File(this.resultDir, fileName).isFile());
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        try (InputStream is = Files.newInputStream(new File(this.resultDir, fileName).toPath(), new OpenOption[0]);){
            byte[] actual = IOUtils.toByteArray((InputStream)is);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }
}

