/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.memory;

import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.memory.MemoryArchiveEntry;

public final class MemoryArchiveInputStream
extends ArchiveInputStream {
    private final String[] filenames;
    private final String[] content;
    private int p;

    public MemoryArchiveInputStream(String[][] pFiles) {
        int pFilesLength = pFiles.length;
        this.filenames = new String[pFilesLength];
        this.content = new String[pFilesLength];
        for (int i = 0; i < pFilesLength; ++i) {
            String[] nameAndContent = pFiles[i];
            this.filenames[i] = nameAndContent[0];
            this.content[i] = nameAndContent[1];
        }
        this.p = 0;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        if (this.p >= this.filenames.length) {
            return null;
        }
        return new MemoryArchiveEntry(this.filenames[this.p]);
    }

    public String readString() {
        return this.content[this.p++];
    }

    public int read() throws IOException {
        return 0;
    }
}

