/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.UnixStat;
import org.junit.Assert;
import org.junit.Test;

public class AsiExtraFieldTest
implements UnixStat {
    @Test
    public void testModes() {
        AsiExtraField a = new AsiExtraField();
        a.setMode(83);
        Assert.assertEquals((String)"plain file", (long)32851L, (long)a.getMode());
        a.setDirectory(true);
        Assert.assertEquals((String)"directory", (long)16467L, (long)a.getMode());
        a.setLinkedFile("test");
        Assert.assertEquals((String)"symbolic link", (long)41043L, (long)a.getMode());
    }

    @Test
    public void testContent() {
        int i;
        AsiExtraField a = new AsiExtraField();
        a.setMode(83);
        a.setUserId(5);
        a.setGroupId(6);
        byte[] b = a.getLocalFileDataData();
        byte[] expect = new byte[]{-58, 2, 120, -74, 83, -128, 0, 0, 0, 0, 5, 0, 6, 0};
        Assert.assertEquals((String)"no link", (long)expect.length, (long)b.length);
        for (i = 0; i < expect.length; ++i) {
            Assert.assertEquals((String)("no link, byte " + i), (long)expect[i], (long)b[i]);
        }
        a.setLinkedFile("test");
        expect = new byte[]{117, -114, 65, -3, 83, -96, 4, 0, 0, 0, 5, 0, 6, 0, 116, 101, 115, 116};
        b = a.getLocalFileDataData();
        Assert.assertEquals((String)"no link", (long)expect.length, (long)b.length);
        for (i = 0; i < expect.length; ++i) {
            Assert.assertEquals((String)("no link, byte " + i), (long)expect[i], (long)b[i]);
        }
    }

    @Test
    public void testReparse() throws Exception {
        byte[] data = new byte[]{-58, 2, 120, -74, 83, -128, 0, 0, 0, 0, 5, 0, 6, 0};
        AsiExtraField a = new AsiExtraField();
        a.parseFromLocalFileData(data, 0, data.length);
        Assert.assertEquals((String)"length plain file", (long)data.length, (long)a.getLocalFileDataLength().getValue());
        Assert.assertFalse((String)"plain file, no link", (boolean)a.isLink());
        Assert.assertFalse((String)"plain file, no dir", (boolean)a.isDirectory());
        Assert.assertEquals((String)"mode plain file", (long)32851L, (long)a.getMode());
        Assert.assertEquals((String)"uid plain file", (long)5L, (long)a.getUserId());
        Assert.assertEquals((String)"gid plain file", (long)6L, (long)a.getGroupId());
        data = new byte[]{117, -114, 65, -3, 83, -96, 4, 0, 0, 0, 5, 0, 6, 0, 116, 101, 115, 116};
        a = new AsiExtraField();
        a.parseFromLocalFileData(data, 0, data.length);
        Assert.assertEquals((String)"length link", (long)data.length, (long)a.getLocalFileDataLength().getValue());
        Assert.assertTrue((String)"link, is link", (boolean)a.isLink());
        Assert.assertFalse((String)"link, no dir", (boolean)a.isDirectory());
        Assert.assertEquals((String)"mode link", (long)41043L, (long)a.getMode());
        Assert.assertEquals((String)"uid link", (long)5L, (long)a.getUserId());
        Assert.assertEquals((String)"gid link", (long)6L, (long)a.getGroupId());
        Assert.assertEquals((Object)"test", (Object)a.getLinkedFile());
        data = new byte[]{-114, 1, -65, 14, 83, 64, 0, 0, 0, 0, 5, 0, 6, 0};
        a = new AsiExtraField();
        a.parseFromLocalFileData(data, 0, data.length);
        Assert.assertEquals((String)"length dir", (long)data.length, (long)a.getLocalFileDataLength().getValue());
        Assert.assertFalse((String)"dir, no link", (boolean)a.isLink());
        Assert.assertTrue((String)"dir, is dir", (boolean)a.isDirectory());
        Assert.assertEquals((String)"mode dir", (long)16467L, (long)a.getMode());
        Assert.assertEquals((String)"uid dir", (long)5L, (long)a.getUserId());
        Assert.assertEquals((String)"gid dir", (long)6L, (long)a.getGroupId());
        data = new byte[]{0, 0, 0, 0, 83, 64, 0, 0, 0, 0, 5, 0, 6, 0};
        a = new AsiExtraField();
        try {
            a.parseFromLocalFileData(data, 0, data.length);
            Assert.fail((String)"should raise bad CRC exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Bad CRC checksum, expected 0 instead of ebf018e", (Object)e.getMessage());
        }
    }

    @Test
    public void testClone() {
        AsiExtraField s1 = new AsiExtraField();
        s1.setUserId(42);
        s1.setGroupId(12);
        s1.setLinkedFile("foo");
        s1.setMode(420);
        s1.setDirectory(true);
        AsiExtraField s2 = (AsiExtraField)s1.clone();
        Assert.assertNotSame((Object)s1, (Object)s2);
        Assert.assertEquals((long)s1.getUserId(), (long)s2.getUserId());
        Assert.assertEquals((long)s1.getGroupId(), (long)s2.getGroupId());
        Assert.assertEquals((Object)s1.getLinkedFile(), (Object)s2.getLinkedFile());
        Assert.assertEquals((long)s1.getMode(), (long)s2.getMode());
        Assert.assertEquals((Object)s1.isDirectory(), (Object)s2.isDirectory());
    }
}

