/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.junit.Assert;
import org.junit.Test;

public class GeneralPurposeBitTest {
    @Test
    public void testDefaults() {
        Assert.assertFalse((boolean)new GeneralPurposeBit().usesDataDescriptor());
        Assert.assertFalse((boolean)new GeneralPurposeBit().usesUTF8ForNames());
        Assert.assertFalse((boolean)new GeneralPurposeBit().usesEncryption());
        Assert.assertFalse((boolean)new GeneralPurposeBit().usesStrongEncryption());
        byte[] b = new byte[2];
        Assert.assertArrayEquals((byte[])b, (byte[])new GeneralPurposeBit().encode());
    }

    @Test
    public void testParseEdgeCases() {
        Assert.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesDataDescriptor());
        Assert.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesUTF8ForNames());
        Assert.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesEncryption());
        Assert.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesStrongEncryption());
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesDataDescriptor());
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesUTF8ForNames());
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesEncryption());
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesStrongEncryption());
    }

    @Test
    public void testDataDescriptor() {
        byte[] flags = new byte[]{8, 0};
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesDataDescriptor());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useDataDescriptor(true);
        Assert.assertArrayEquals((byte[])flags, (byte[])b.encode());
    }

    @Test
    public void testLanguageEncodingFlag() {
        byte[] flags = new byte[]{0, 8};
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesUTF8ForNames());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useUTF8ForNames(true);
        Assert.assertArrayEquals((byte[])flags, (byte[])b.encode());
    }

    @Test
    public void testEncryption() {
        byte[] flags = new byte[]{1, 0};
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesEncryption());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useEncryption(true);
        Assert.assertArrayEquals((byte[])flags, (byte[])b.encode());
    }

    @Test
    public void testStrongEncryption() {
        byte[] flags = new byte[]{65, 0};
        Assert.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesStrongEncryption());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useStrongEncryption(true);
        Assert.assertTrue((boolean)b.usesEncryption());
        Assert.assertArrayEquals((byte[])flags, (byte[])b.encode());
        flags = new byte[]{64, 0};
        Assert.assertFalse((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesStrongEncryption());
    }

    @Test
    public void testClone() {
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useStrongEncryption(true);
        b.useUTF8ForNames(true);
        Assert.assertEquals((Object)b, (Object)b.clone());
        Assert.assertNotSame((Object)b, (Object)b.clone());
    }
}

