/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.apache.commons.compress.archivers.zip.ScatterSample;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ScatterSampleTest {
    @Test
    public void testSample() throws Exception {
        File result = File.createTempFile("testSample", "fe");
        this.createFile(result);
        this.checkFile(result);
    }

    private void createFile(File result) throws IOException, ExecutionException, InterruptedException {
        ScatterSample scatterSample = new ScatterSample();
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry("test1.xml");
        archiveEntry.setMethod(8);
        InputStreamSupplier supp = () -> new ByteArrayInputStream("Hello".getBytes());
        scatterSample.addEntry(archiveEntry, supp);
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(result);){
            scatterSample.writeTo(zipArchiveOutputStream);
        }
    }

    private void checkFile(File result) throws IOException {
        try (ZipFile zipFile = new ZipFile(result);){
            ZipArchiveEntry archiveEntry1 = (ZipArchiveEntry)zipFile.getEntries().nextElement();
            Assert.assertEquals((Object)"test1.xml", (Object)archiveEntry1.getName());
            try (InputStream inputStream = zipFile.getInputStream(archiveEntry1);){
                byte[] b = new byte[6];
                int i = IOUtils.readFully((InputStream)inputStream, (byte[])b);
                Assert.assertEquals((long)5L, (long)i);
                Assert.assertEquals((long)72L, (long)b[0]);
                Assert.assertEquals((long)111L, (long)b[4]);
            }
        }
        result.delete();
    }
}

