/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.Assert;
import org.junit.Test;

public class Zip64ExtendedInformationExtraFieldTest {
    private static final ZipEightByteInteger SIZE = new ZipEightByteInteger(305419896L);
    private static final ZipEightByteInteger CSIZE = new ZipEightByteInteger(162254319L);
    private static final ZipEightByteInteger OFF = new ZipEightByteInteger(BigInteger.valueOf(773738360809407847L).shiftLeft(4).setBit(3));
    private static final ZipLong DISK = new ZipLong(18);

    @Test
    public void testWriteCDOnlySizes() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE);
        Assert.assertEquals((Object)new ZipShort(16), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assert.assertEquals((long)16L, (long)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
    }

    @Test
    public void testWriteCDSizeAndOffset() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, OFF, null);
        Assert.assertEquals((Object)new ZipShort(24), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assert.assertEquals((long)24L, (long)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkOffset(b, 16);
    }

    @Test
    public void testWriteCDSizeOffsetAndDisk() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, OFF, DISK);
        Assert.assertEquals((Object)new ZipShort(28), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assert.assertEquals((long)28L, (long)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkOffset(b, 16);
        Zip64ExtendedInformationExtraFieldTest.checkDisk(b, 24);
    }

    @Test
    public void testWriteCDSizeAndDisk() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, null, DISK);
        Assert.assertEquals((Object)new ZipShort(20), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assert.assertEquals((long)20L, (long)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkDisk(b, 16);
    }

    @Test
    public void testReadLFHSizesOnly() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[16];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        f.parseFromLocalFileData(b, 0, b.length);
        Assert.assertEquals((Object)SIZE, (Object)f.getSize());
        Assert.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assert.assertNull((Object)f.getRelativeHeaderOffset());
        Assert.assertNull((Object)f.getDiskStartNumber());
    }

    @Test
    public void testReadLFHSizesAndOffset() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[24];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        f.parseFromLocalFileData(b, 0, b.length);
        Assert.assertEquals((Object)SIZE, (Object)f.getSize());
        Assert.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assert.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assert.assertNull((Object)f.getDiskStartNumber());
    }

    @Test
    public void testReadLFHSizesOffsetAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[28];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 24, 4);
        f.parseFromLocalFileData(b, 0, b.length);
        Assert.assertEquals((Object)SIZE, (Object)f.getSize());
        Assert.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assert.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assert.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    public void testReadLFHSizesAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[20];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 16, 4);
        f.parseFromLocalFileData(b, 0, b.length);
        Assert.assertEquals((Object)SIZE, (Object)f.getSize());
        Assert.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assert.assertNull((Object)f.getRelativeHeaderOffset());
        Assert.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    public void testReadCDSizesOffsetAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[28];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 24, 4);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Assert.assertEquals((Object)SIZE, (Object)f.getSize());
        Assert.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assert.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assert.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    public void testReadCDSizesAndOffset() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[24];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Assert.assertEquals((Object)SIZE, (Object)f.getSize());
        Assert.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assert.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assert.assertNull((Object)f.getDiskStartNumber());
    }

    @Test
    public void testReadCDSomethingAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[12];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 8, 4);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Assert.assertNull((Object)f.getSize());
        Assert.assertNull((Object)f.getCompressedSize());
        Assert.assertNull((Object)f.getRelativeHeaderOffset());
        Assert.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    public void testReparseCDSingleEightByteData() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[8];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        f.reparseCentralDirectoryData(true, false, false, false);
        Assert.assertEquals((Object)SIZE, (Object)f.getSize());
        Assert.assertNull((Object)f.getCompressedSize());
        Assert.assertNull((Object)f.getRelativeHeaderOffset());
        Assert.assertNull((Object)f.getDiskStartNumber());
        f.setSize(null);
        f.reparseCentralDirectoryData(false, true, false, false);
        Assert.assertNull((Object)f.getSize());
        Assert.assertEquals((Object)SIZE, (Object)f.getCompressedSize());
        Assert.assertNull((Object)f.getRelativeHeaderOffset());
        Assert.assertNull((Object)f.getDiskStartNumber());
        f.setCompressedSize(null);
        f.reparseCentralDirectoryData(false, false, true, false);
        Assert.assertNull((Object)f.getSize());
        Assert.assertNull((Object)f.getCompressedSize());
        Assert.assertEquals((Object)SIZE, (Object)f.getRelativeHeaderOffset());
        Assert.assertNull((Object)f.getDiskStartNumber());
    }

    private static void checkSizes(byte[] b) {
        Assert.assertEquals((long)120L, (long)b[0]);
        Assert.assertEquals((long)86L, (long)b[1]);
        Assert.assertEquals((long)52L, (long)b[2]);
        Assert.assertEquals((long)18L, (long)b[3]);
        Assert.assertEquals((long)0L, (long)b[4]);
        Assert.assertEquals((long)0L, (long)b[5]);
        Assert.assertEquals((long)0L, (long)b[6]);
        Assert.assertEquals((long)0L, (long)b[7]);
        Assert.assertEquals((long)-17L, (long)b[8]);
        Assert.assertEquals((long)-51L, (long)b[9]);
        Assert.assertEquals((long)-85L, (long)b[10]);
        Assert.assertEquals((long)9L, (long)b[11]);
        Assert.assertEquals((long)0L, (long)b[12]);
        Assert.assertEquals((long)0L, (long)b[13]);
        Assert.assertEquals((long)0L, (long)b[14]);
        Assert.assertEquals((long)0L, (long)b[15]);
    }

    private static void checkOffset(byte[] b, int off) {
        Assert.assertEquals((long)120L, (long)b[0 + off]);
        Assert.assertEquals((long)86L, (long)b[1 + off]);
        Assert.assertEquals((long)52L, (long)b[2 + off]);
        Assert.assertEquals((long)18L, (long)b[3 + off]);
        Assert.assertEquals((long)9L, (long)b[4 + off]);
        Assert.assertEquals((long)-17L, (long)b[5 + off]);
        Assert.assertEquals((long)-51L, (long)b[6 + off]);
        Assert.assertEquals((long)-85L, (long)b[7 + off]);
    }

    private static void checkDisk(byte[] b, int off) {
        Assert.assertEquals((long)18L, (long)b[0 + off]);
        Assert.assertEquals((long)0L, (long)b[1 + off]);
        Assert.assertEquals((long)0L, (long)b[2 + off]);
        Assert.assertEquals((long)0L, (long)b[3 + off]);
    }
}

