/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipSplitOutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZipSplitOutputStreamTest
extends AbstractTestCase {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void throwsExceptionIfSplitSizeIsTooSmall() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 65535L);
    }

    @Test
    public void throwsExceptionIfSplitSizeIsTooLarge() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 0x100000000L);
    }

    @Test
    public void throwsIfUnsplittableSizeLargerThanSplitSize() throws IOException {
        this.thrown.expect(IllegalArgumentException.class);
        long splitSize = 102400L;
        ZipSplitOutputStream output = new ZipSplitOutputStream(File.createTempFile("temp", "zip"), 102400L);
        output.prepareToWriteUnsplittableContent(102401L);
    }

    @Test
    public void splitZipBeginsWithZipSplitSignature() throws IOException {
        File tempFile = File.createTempFile("temp", "zip");
        new ZipSplitOutputStream(tempFile, 102400L);
        InputStream inputStream = Files.newInputStream(tempFile.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[4];
        inputStream.read(buffer);
        Assert.assertEquals((long)ByteBuffer.wrap(ZipArchiveOutputStream.DD_SIG).getInt(), (long)ByteBuffer.wrap(buffer).getInt());
    }

    @Test
    public void testCreateSplittedFiles() throws IOException {
        int readLen;
        File testOutputFile = new File(this.dir, "testCreateSplittedFiles.zip");
        int splitSize = 102400;
        ZipSplitOutputStream zipSplitOutputStream = new ZipSplitOutputStream(testOutputFile, 102400L);
        File fileToTest = ZipSplitOutputStreamTest.getFile("COMPRESS-477/split_zip_created_by_zip/zip_to_compare_created_by_zip.zip");
        InputStream inputStream = Files.newInputStream(fileToTest.toPath(), new OpenOption[0]);
        byte[] buffer = new byte[4096];
        while ((readLen = inputStream.read(buffer)) > 0) {
            zipSplitOutputStream.write(buffer, 0, readLen);
        }
        inputStream.close();
        zipSplitOutputStream.close();
        File zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z01");
        Assert.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z02");
        Assert.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z03");
        Assert.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z04");
        Assert.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.z05");
        Assert.assertEquals((long)zipFile.length(), (long)102400L);
        zipFile = new File(this.dir.getPath(), "testCreateSplittedFiles.zip");
        Assert.assertEquals((long)zipFile.length(), (long)(fileToTest.length() + 4L - 512000L));
    }
}

