/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import org.apache.commons.compress.compressors.bzip2.BZip2Utils;
import org.junit.Assert;
import org.junit.Test;

public class BZip2UtilsTestCase {
    @Test
    public void testIsCompressedFilename() {
        Assert.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)""));
        Assert.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)".gz"));
        Assert.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz2"));
        Assert.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz"));
        Assert.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.bz2"));
        Assert.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.bz"));
        Assert.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"xbz2"));
        Assert.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"xbz"));
        Assert.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.TBZ2"));
        Assert.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.Tbz2"));
        Assert.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbZ2"));
        Assert.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.bz "));
        Assert.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz\n"));
        Assert.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz2.y"));
    }

    @Test
    public void testGetUncompressedFilename() {
        Assert.assertEquals((Object)"", (Object)BZip2Utils.getUncompressedFilename((String)""));
        Assert.assertEquals((Object)".bz2", (Object)BZip2Utils.getUncompressedFilename((String)".bz2"));
        Assert.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz2"));
        Assert.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz"));
        Assert.assertEquals((Object)"x", (Object)BZip2Utils.getUncompressedFilename((String)"x.bz2"));
        Assert.assertEquals((Object)"x", (Object)BZip2Utils.getUncompressedFilename((String)"x.bz"));
        Assert.assertEquals((Object)"x.tar", (Object)BZip2Utils.getUncompressedFilename((String)"x.TBZ2"));
        Assert.assertEquals((Object)"X.tar", (Object)BZip2Utils.getUncompressedFilename((String)"X.Tbz2"));
        Assert.assertEquals((Object)"X.tar", (Object)BZip2Utils.getUncompressedFilename((String)"X.tbZ2"));
        Assert.assertEquals((Object)"x.bz ", (Object)BZip2Utils.getUncompressedFilename((String)"x.bz "));
        Assert.assertEquals((Object)"x.tbz\n", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz\n"));
        Assert.assertEquals((Object)"x.tbz2.y", (Object)BZip2Utils.getUncompressedFilename((String)"x.tbz2.y"));
    }

    @Test
    public void testGetCompressedFilename() {
        Assert.assertEquals((Object)".bz2", (Object)BZip2Utils.getCompressedFilename((String)""));
        Assert.assertEquals((Object)" .bz2", (Object)BZip2Utils.getCompressedFilename((String)" "));
        Assert.assertEquals((Object)"x.bz2", (Object)BZip2Utils.getCompressedFilename((String)"x"));
        Assert.assertEquals((Object)"X.bz2", (Object)BZip2Utils.getCompressedFilename((String)"X"));
        Assert.assertEquals((Object)"x.tar.bz2", (Object)BZip2Utils.getCompressedFilename((String)"x.tar"));
        Assert.assertEquals((Object)"x.tar.bz2", (Object)BZip2Utils.getCompressedFilename((String)"x.TAR"));
    }
}

