/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.brotli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.brotli.BrotliUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class BrotliCompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void testBrotliDecode() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        File expected = BrotliCompressorInputStreamTest.getFile("brotli.testdata.uncompressed");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             BrotliCompressorInputStream brotliInputStream = new BrotliCompressorInputStream(inputStream);){
            byte[] b = new byte[20];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = brotliInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assert.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testCachingIsEnabledByDefaultAndBrotliIsPresent() {
        Assert.assertEquals((Object)BrotliUtils.CachedAvailability.CACHED_AVAILABLE, (Object)BrotliUtils.getCachedBrotliAvailability());
        Assert.assertTrue((boolean)BrotliUtils.isBrotliCompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            BrotliUtils.setCacheBrotliAvailablity((boolean)false);
            Assert.assertEquals((Object)BrotliUtils.CachedAvailability.DONT_CACHE, (Object)BrotliUtils.getCachedBrotliAvailability());
            Assert.assertTrue((boolean)BrotliUtils.isBrotliCompressionAvailable());
        }
        finally {
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
        }
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            BrotliUtils.setCacheBrotliAvailablity((boolean)false);
            Assert.assertEquals((Object)BrotliUtils.CachedAvailability.DONT_CACHE, (Object)BrotliUtils.getCachedBrotliAvailability());
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
            Assert.assertEquals((Object)BrotliUtils.CachedAvailability.CACHED_AVAILABLE, (Object)BrotliUtils.getCachedBrotliAvailability());
        }
        finally {
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
        }
    }

    @Test
    public void availableShouldReturnZero() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);
            Assert.assertEquals((long)0L, (long)in.available());
            in.close();
        }
    }

    @Test
    public void shouldBeAbleToSkipAByte() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);
            Assert.assertEquals((long)1L, (long)in.skip(1L));
            in.close();
        }
    }

    @Test
    public void singleByteReadWorksAsExpected() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);
            Assert.assertEquals((long)88L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BrotliCompressorInputStreamTest.getFile("brotli.testdata.compressed");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }

    @Test
    public void testBrotliUnarchive() throws Exception {
        File input = BrotliCompressorInputStreamTest.getFile("bla.tar.br");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("br", is);
             OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

