/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class FactoryTest
extends AbstractTestCase {
    @Test
    public void frameRoundtripViaFactory() throws Exception {
        this.roundtripViaFactory(CompressorStreamFactory.getLZ4Framed());
    }

    @Test
    public void blockRoundtripViaFactory() throws Exception {
        this.roundtripViaFactory(CompressorStreamFactory.getLZ4Block());
    }

    private void roundtripViaFactory(String format) throws Exception {
        Throwable throwable;
        File input = FactoryTest.getFile("bla.tar");
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + "." + format + ".lz4");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            throwable = null;
            try (OutputStream os = Files.newOutputStream(outputSz.toPath(), new OpenOption[0]);
                 CompressorOutputStream los2 = new CompressorStreamFactory().createCompressorOutputStream(format, os);){
                IOUtils.copy((InputStream)is, (OutputStream)los2);
            }
            catch (Throwable los2) {
                throwable = los2;
                throw los2;
            }
        }
        System.err.println(input.getName() + " written, uncompressed bytes: " + input.length() + ", compressed bytes: " + outputSz.length() + " after " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        is = Files.newInputStream(input.toPath(), new OpenOption[0]);
        var7_6 = null;
        try {
            throwable = null;
            try (CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream(format, Files.newInputStream(outputSz.toPath(), new OpenOption[0]));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var7_6 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var7_6 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var7_6.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
        System.err.println(outputSz.getName() + " read after " + (System.currentTimeMillis() - start) + "ms");
    }
}

