/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.z;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZCompressorInputStreamTest {
    @Test(expected=IOException.class)
    public void testFailsToCreateZCompressorInputStreamAndThrowsIOException() throws IOException {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.emptyEnumeration());
        ZCompressorInputStream zCompressorInputStream = new ZCompressorInputStream((InputStream)sequenceInputStream);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.Z");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            ZCompressorInputStream in = new ZCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.Z");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            ZCompressorInputStream in = new ZCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }
}

