/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.RecyclingBufferPool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZstdCompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void testZstdDecode() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File expected = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream zstdInputStream = new ZstdCompressorInputStream(inputStream);){
            byte[] b = new byte[97];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = zstdInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assert.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testZstdDecodeWithNoPool() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File expected = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream zstdInputStream = new ZstdCompressorInputStream(inputStream, NoPool.INSTANCE);){
            byte[] b = new byte[97];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = zstdInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assert.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testZstdDecodeWithRecyclingBufferPool() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File expected = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        try (InputStream inputStream = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ZstdCompressorInputStream zstdInputStream = new ZstdCompressorInputStream(inputStream, RecyclingBufferPool.INSTANCE);){
            byte[] b = new byte[97];
            IOUtils.read((File)expected, (byte[])b);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = zstdInputStream.read()) != -1) {
                bos.write(readByte);
            }
            Assert.assertArrayEquals((byte[])b, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testCachingIsEnabledByDefaultAndZstdUtilsPresent() {
        Assert.assertEquals((Object)ZstdUtils.CachedAvailability.CACHED_AVAILABLE, (Object)ZstdUtils.getCachedZstdAvailability());
        Assert.assertTrue((boolean)ZstdUtils.isZstdCompressionAvailable());
    }

    @Test
    public void testCanTurnOffCaching() {
        try {
            ZstdUtils.setCacheZstdAvailablity((boolean)false);
            Assert.assertEquals((Object)ZstdUtils.CachedAvailability.DONT_CACHE, (Object)ZstdUtils.getCachedZstdAvailability());
            Assert.assertTrue((boolean)ZstdUtils.isZstdCompressionAvailable());
        }
        finally {
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
        }
    }

    @Test
    public void testTurningOnCachingReEvaluatesAvailability() {
        try {
            ZstdUtils.setCacheZstdAvailablity((boolean)false);
            Assert.assertEquals((Object)ZstdUtils.CachedAvailability.DONT_CACHE, (Object)ZstdUtils.getCachedZstdAvailability());
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
            Assert.assertEquals((Object)ZstdUtils.CachedAvailability.CACHED_AVAILABLE, (Object)ZstdUtils.getCachedZstdAvailability());
        }
        finally {
            ZstdUtils.setCacheZstdAvailablity((boolean)true);
        }
    }

    @Test
    public void shouldBeAbleToSkipAByte() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);
            Assert.assertEquals((long)1L, (long)in.skip(1L));
            in.close();
        }
    }

    @Test
    public void singleByteReadWorksAsExpected() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        File original = ZstdCompressorInputStreamTest.getFile("zstandard.testdata");
        long originalFileLength = original.length();
        byte[] originalFileContent = new byte[(int)originalFileLength];
        try (InputStream ois = Files.newInputStream(original.toPath(), new OpenOption[0]);){
            ois.read(originalFileContent);
        }
        var7_6 = null;
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);
            Assert.assertEquals((long)originalFileContent[0], (long)in.read());
            in.close();
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = ZstdCompressorInputStreamTest.getFile("zstandard.testdata.zst");
        byte[] buf = new byte[2];
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            ZstdCompressorInputStream in = new ZstdCompressorInputStream(is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }

    @Test
    public void testZstandardUnarchive() throws Exception {
        File input = ZstdCompressorInputStreamTest.getFile("bla.tar.zst");
        File output = new File(this.dir, "bla.tar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("zstd", is);
             OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

