/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200.tests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.harmony.pack200.Archive;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PackingOptions;
import org.apache.commons.compress.harmony.unpack200.Segment;

public class ArchiveTest
extends TestCase {
    JarFile in;
    OutputStream out;
    File file;

    public void testHelloWorld() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/hw.jar").toURI()));
        this.file = File.createTempFile("helloworld", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        new Archive(this.in, this.out, null).pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("helloworld", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        archive.unpack();
        out2.close();
        ((InputStream)in2).close();
        JarFile jarFile = new JarFile(file2);
        JarEntry entry = jarFile.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
        ArchiveTest.assertNotNull((Object)entry);
        InputStream ours = jarFile.getInputStream(entry);
        JarFile jarFile2 = new JarFile(new File(Segment.class.getResource("/pack200/hw.jar").toURI()));
        JarEntry entry2 = jarFile2.getJarEntry("org/apache/harmony/archive/tests/internal/pack200/HelloWorld.class");
        ArchiveTest.assertNotNull((Object)entry2);
        InputStream expected = jarFile2.getInputStream(entry2);
        BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
        BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));
        String line1 = reader1.readLine();
        String line2 = reader2.readLine();
        int i = 1;
        while (line1 != null || line2 != null) {
            ArchiveTest.assertEquals((String)"Unpacked class files differ", (String)line2, (String)line1);
            line1 = reader1.readLine();
            line2 = reader2.readLine();
            ++i;
        }
        reader1.close();
        reader2.close();
    }

    public void testSQL() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI()));
        this.file = File.createTempFile("sql", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        Archive ar = new Archive(this.in, this.out, options);
        ar.pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("sqlout", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        archive.unpack();
        JarFile jarFile = new JarFile(file2);
        File compareFile = new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI());
        JarFile jarFile2 = new JarFile(compareFile);
        ArchiveTest.assertEquals((int)jarFile2.size(), (int)jarFile.size());
        this.compareFiles(jarFile, jarFile2);
    }

    public void testAlternativeConstructor() throws FileNotFoundException, IOException, URISyntaxException, Pack200Exception {
        JarInputStream inStream = new JarInputStream(new FileInputStream(new File(Archive.class.getResource("/pack200/sqlUnpacked.jar").toURI())));
        this.file = File.createTempFile("sql", ".pack.gz");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        new Archive(inStream, this.out, null).pack();
        inStream.close();
        this.out.close();
    }

    public void testLargeClass() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/largeClassUnpacked.jar").toURI()));
        this.file = File.createTempFile("largeClass", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("largeClassOut", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        archive.unpack();
        JarFile jarFile = new JarFile(file2);
        File compareFile = new File(Archive.class.getResource("/pack200/largeClassUnpacked.jar").toURI());
        JarFile jarFile2 = new JarFile(compareFile);
        ArchiveTest.assertEquals((int)jarFile2.size(), (int)jarFile.size());
        this.compareFiles(jarFile, jarFile2);
    }

    public void testJNDI() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/jndi.jar").toURI()));
        this.file = File.createTempFile("jndi", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("jndiout", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        archive.unpack();
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/jndiUnpacked.jar").toURI()));
        this.compareFiles(jarFile, jarFile2);
    }

    public void testAnnotations() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/annotationsUnpacked.jar").toURI()));
        this.file = File.createTempFile("annotations", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("annotationsout", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        archive.unpack();
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/annotationsUnpacked.jar").toURI()));
        this.compareFiles(jarFile, jarFile2);
    }

    public void testAnnotations2() throws IOException, Pack200Exception, URISyntaxException {
        this.in = new JarFile(new File(Archive.class.getResource("/pack200/annotations.jar").toURI()));
        this.file = File.createTempFile("annotations", ".pack");
        this.file.deleteOnExit();
        this.out = new FileOutputStream(this.file);
        PackingOptions options = new PackingOptions();
        options.setGzip(false);
        new Archive(this.in, this.out, options).pack();
        this.in.close();
        this.out.close();
        FileInputStream in2 = new FileInputStream(this.file);
        File file2 = File.createTempFile("annotationsout", ".jar");
        file2.deleteOnExit();
        JarOutputStream out2 = new JarOutputStream(new FileOutputStream(file2));
        org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive((InputStream)in2, out2);
        archive.unpack();
        JarFile jarFile = new JarFile(file2);
        JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/annotationsRI.jar").toURI()));
        this.compareFiles(jarFile, jarFile2);
    }

    public void testWithAnnotations2() throws Exception {
        InputStream i = Archive.class.getResourceAsStream("/pack200/annotationsRI.pack.gz");
        this.file = File.createTempFile("annotations", ".jar");
        this.file.deleteOnExit();
        JarOutputStream jout = new JarOutputStream(new FileOutputStream(this.file));
        org.apache.commons.compress.harmony.unpack200.Archive archive = new org.apache.commons.compress.harmony.unpack200.Archive(i, jout);
        archive.unpack();
        JarFile jarFile = new JarFile(this.file);
        JarFile jarFile2 = new JarFile(new File(Archive.class.getResource("/pack200/annotationsRI.jar").toURI()));
        this.compareFiles(jarFile, jarFile2);
    }

    public void testMultipleJars() throws URISyntaxException, IOException, Pack200Exception {
        File folder = new File(Archive.class.getResource("/pack200/jars").toURI());
        String[] children = folder.list();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].endsWith(".jar") || children[i].endsWith("Unpacked.jar")) continue;
            File inputFile = new File(folder, children[i]);
            this.in = new JarFile(inputFile);
            this.file = File.createTempFile("temp", ".pack.gz");
            this.file.deleteOnExit();
            this.out = new FileOutputStream(this.file);
            new Archive(this.in, this.out, null).pack();
            this.in.close();
            this.out.close();
        }
    }

    private void compareJarEntries(JarFile jarFile, JarFile jarFile2) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            ArchiveTest.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            ArchiveTest.assertNotNull((String)("Missing Entry: " + name), (Object)entry2);
        }
    }

    private void compareFiles(JarFile jarFile, JarFile jarFile2) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            ArchiveTest.assertNotNull((Object)entry);
            String name = entry.getName();
            JarEntry entry2 = jarFile2.getJarEntry(name);
            ArchiveTest.assertNotNull((String)("Missing Entry: " + name), (Object)entry2);
            if (name.equals("META-INF/MANIFEST.MF")) continue;
            InputStream ours = jarFile.getInputStream(entry);
            InputStream expected = jarFile2.getInputStream(entry2);
            BufferedReader reader1 = new BufferedReader(new InputStreamReader(ours));
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(expected));
            String line1 = reader1.readLine();
            String line2 = reader2.readLine();
            int i = 1;
            while (line1 != null || line2 != null) {
                ArchiveTest.assertEquals((String)("Unpacked files differ for " + name), (String)line2, (String)line1);
                line1 = reader1.readLine();
                line2 = reader2.readLine();
                ++i;
            }
            reader1.close();
            reader2.close();
        }
        jarFile.close();
        jarFile2.close();
    }
}

