/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200.tests;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.harmony.pack200.BHSDCodec;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.CodecEncoding;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;

public class BHSDCodecTest
extends TestCase {
    public void testEncodeDecode() throws IOException, Pack200Exception {
        for (int i = 1; i < 116; ++i) {
            BHSDCodec codec = (BHSDCodec)CodecEncoding.getCodec((int)i, null, null);
            if (!codec.isDelta()) {
                long smallest;
                long largest = codec.largest();
                long l = smallest = codec.isSigned() ? codec.smallest() : 0L;
                if (smallest < Integer.MIN_VALUE) {
                    smallest = Integer.MIN_VALUE;
                }
                long difference = (largest - smallest) / 4L;
                for (long j = smallest; j <= largest && j <= Integer.MAX_VALUE; j += difference) {
                    byte[] encoded = codec.encode((int)j, 0);
                    long decoded = 0L;
                    try {
                        decoded = codec.decode((InputStream)new ByteArrayInputStream(encoded), 0L);
                    }
                    catch (EOFException e) {
                        System.out.println(e);
                    }
                    if (j == decoded) continue;
                    BHSDCodecTest.fail((String)("Failed with codec: " + i + ", " + codec + " expected: " + j + ", got: " + decoded));
                }
            }
            BHSDCodecTest.assertEquals((int)0, (int)codec.decode((InputStream)new ByteArrayInputStream(codec.encode(0, 0)), 0L));
        }
    }

    public void testDeltaEncodings() throws IOException, Pack200Exception {
        BHSDCodec c = Codec.UDELTA5;
        int[] sequence = new int[]{0, 2, 4, 2, 2, 4};
        byte[] encoded = c.encode(sequence);
        int[] decoded = c.decodeInts(6, (InputStream)new ByteArrayInputStream(encoded));
        for (int i = 0; i < decoded.length; ++i) {
            BHSDCodecTest.assertEquals((int)sequence[i], (int)decoded[i]);
        }
    }
}

