/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.compress.harmony.pack200.BHSDCodec;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.pack200.PopulationCodec;

public class PopulationCodecTest
extends TestCase {
    public void testPopulationCodec() throws IOException, Pack200Exception {
        this.checkDecode(new byte[]{4, 5, 6, 4, 2, 1, 3, 0, 7}, new long[]{5L, 4L, 6L, 7L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{8, 7, 12, 8, 4, 2, 6, 0, 14}, new long[]{-4L, 4L, 6L, 7L}, (Codec)Codec.SIGNED5);
        this.checkDecode(new byte[]{7, 8, 12, 8, 4, 2, 6, 0, 14}, new long[]{4L, -4L, 6L, 7L}, (Codec)Codec.SIGNED5);
        this.checkDecode(new byte[]{1, 1, 1}, new long[]{1L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{2, 2, 1}, new long[]{2L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{1, 1, 2}, new long[]{-1L}, (Codec)Codec.SIGNED5);
        this.checkDecode(new byte[]{2, 2, 0, 1, 3}, new long[]{3L, 2L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{1, 2, 3, 4, 4, 2, 3, 4, 0, 1}, new long[]{2L, 3L, 4L, 1L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{3, 2, 1, 4, 4, 2, 3, 4, 0, 1}, new long[]{2L, 1L, 4L, 1L}, (Codec)Codec.BYTE1);
        this.checkDecode(new byte[]{3, 2, 1, 4, 1, 2, 3, 4, 0, 1}, new long[]{2L, 1L, 4L, 1L}, (Codec)Codec.BYTE1);
    }

    private void checkDecode(byte[] data, long[] expectedResult, Codec codec) throws IOException, Pack200Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        int[] result = new PopulationCodec(codec, codec, codec).decodeInts(expectedResult.length, (InputStream)in);
        PopulationCodecTest.assertEquals((int)expectedResult.length, (int)result.length);
        for (int i = 0; i < expectedResult.length; ++i) {
            PopulationCodecTest.assertEquals((long)expectedResult[i], (long)result[i]);
        }
        PopulationCodecTest.assertEquals((int)0, (int)((InputStream)in).available());
    }

    public void testEncodeSingleValue() {
        try {
            new PopulationCodec((Codec)BHSDCodec.SIGNED5, (Codec)BHSDCodec.SIGNED5, (Codec)BHSDCodec.UDELTA5).encode(5);
            PopulationCodecTest.fail((String)"Should not allow a single value to be encoded as we don't know which codec to use");
        }
        catch (Pack200Exception pack200Exception) {
            // empty catch block
        }
        try {
            new PopulationCodec((Codec)BHSDCodec.SIGNED5, (Codec)BHSDCodec.SIGNED5, (Codec)BHSDCodec.UDELTA5).encode(5, 8);
            PopulationCodecTest.fail((String)"Should not allow a single value to be encoded as we don't know which codec to use");
        }
        catch (Pack200Exception pack200Exception) {
            // empty catch block
        }
    }
}

