/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.AttrDefinitionBands;
import org.apache.commons.compress.harmony.unpack200.BcBands;
import org.apache.commons.compress.harmony.unpack200.ClassBands;
import org.apache.commons.compress.harmony.unpack200.CpBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.SegmentConstantPool;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPClass;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPDouble;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPFieldRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPFloat;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPInteger;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPInterfaceMethodRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPLong;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPMethodRef;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPNameAndType;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPString;
import org.apache.commons.compress.harmony.unpack200.bytecode.CPUTF8;
import org.apache.commons.compress.harmony.unpack200.tests.AbstractBandsTestCase;

public class BcBandsTest
extends AbstractBandsTestCase {
    BcBands bcBands = new BcBands((Segment)new MockSegment());

    public void testSimple() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, -128, -127, -126, -125, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -84, -83, -82, -81, -80, -79, -66, -65, -62, -61, -1};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)(bytes.length - 1), (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
    }

    public void testMultipleClassesSimple() throws IOException, Pack200Exception {
        this.numClasses = 2;
        this.numMethods = new int[]{1, 1};
        byte[] bytes = new byte[]{50, 50, -1, 50, 50, -1};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        this.numClasses = 1;
        this.numMethods = new int[]{1};
    }

    public void testMultipleMethodsSimple() throws IOException, Pack200Exception {
        this.numClasses = 2;
        this.numMethods = new int[]{3, 1};
        byte[] bytes = new byte[]{50, 50, -1, 50, 50, -1, 50, 50, -1, 50, 50, -1};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        this.numClasses = 1;
        this.numMethods = new int[]{1};
    }

    public void testBcCaseBands() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-86, -85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 2, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)18, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_case_count = this.bcBands.getBcCaseCount();
        BcBandsTest.assertEquals((int)2, (int)bc_case_count.length);
        BcBandsTest.assertEquals((int)2, (int)bc_case_count[0]);
        BcBandsTest.assertEquals((int)5, (int)bc_case_count[1]);
        int[] bc_case_value = this.bcBands.getBcCaseValue();
        BcBandsTest.assertEquals((int)0, (int)bc_case_value[0]);
        BcBandsTest.assertEquals((int)0, (int)bc_case_value[1]);
        BcBandsTest.assertEquals((int)9, (int)this.bcBands.getBcLabel().length);
    }

    public void testBcByteBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{16, -124, -68, -59, -1, 8, 8, 8, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)4, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_byte = this.bcBands.getBcByte();
        BcBandsTest.assertEquals((int)4, (int)bc_byte.length);
        for (int i = 0; i < bc_byte.length; ++i) {
            BcBandsTest.assertEquals((int)8, (int)bc_byte[i]);
        }
        BcBandsTest.assertEquals((int)1, (int)this.bcBands.getBcLocal().length);
        BcBandsTest.assertEquals((int)1, (int)this.bcBands.getBcClassRef().length);
    }

    public void testBcShortBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{17, -60, -124, -1, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)3, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getBcShort().length);
        BcBandsTest.assertEquals((int)1, (int)this.bcBands.getBcLocal().length);
    }

    public void testBcLocalBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{21, 22, 23, 24, 25, 54, 55, 56, 57, 58, -87, -1, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)11, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        BcBandsTest.assertEquals((int)11, (int)this.bcBands.getBcLocal().length);
    }

    public void testBcLabelBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -86, -85, -58, -57, -56, -55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)36, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        BcBandsTest.assertEquals((int)20, (int)this.bcBands.getBcLabel().length);
    }

    public void testWideForms() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-60, 54, -60, -124, -1, 0, 0, 1};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)4, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getBcLocal().length);
        BcBandsTest.assertEquals((int)1, (int)this.bcBands.getBcShort().length);
    }

    public void testBcIntRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-22, -19, -1, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_intref = this.bcBands.getBcIntRef();
        BcBandsTest.assertEquals((int)2, (int)bc_intref.length);
    }

    public void testBcFloatRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-21, -18, -1, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_floatref = this.bcBands.getBcFloatRef();
        BcBandsTest.assertEquals((int)2, (int)bc_floatref.length);
    }

    public void testBcLongRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{20, -1, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)1, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_longref = this.bcBands.getBcLongRef();
        BcBandsTest.assertEquals((int)1, (int)bc_longref.length);
    }

    public void testBcDoubleRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-17, -1, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)1, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_doubleref = this.bcBands.getBcDoubleRef();
        BcBandsTest.assertEquals((int)1, (int)bc_doubleref.length);
    }

    public void testBcStringRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{18, 19, -1, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_stringref = this.bcBands.getBcStringRef();
        BcBandsTest.assertEquals((int)2, (int)bc_stringref.length);
    }

    public void testBcClassRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-23, -20, -1, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)2, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_classref = this.bcBands.getBcClassRef();
        BcBandsTest.assertEquals((int)2, (int)bc_classref.length);
    }

    public void testBcFieldRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-78, -77, -76, -75, -1, 8, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)4, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_fieldref = this.bcBands.getBcFieldRef();
        BcBandsTest.assertEquals((int)4, (int)bc_fieldref.length);
    }

    public void testBcMethodRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-74, -73, -72, -1, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)3, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_methodref = this.bcBands.getBcMethodRef();
        BcBandsTest.assertEquals((int)3, (int)bc_methodref.length);
    }

    public void testBcIMethodRefBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-71, -1, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)1, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_imethodref = this.bcBands.getBcIMethodRef();
        BcBandsTest.assertEquals((int)1, (int)bc_imethodref.length);
    }

    public void testBcThisFieldBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-54, -53, -52, -51, -47, -46, -45, -44, -1, 8, 8, 8, 8, 8, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)8, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_thisfield = this.bcBands.getBcThisField();
        BcBandsTest.assertEquals((int)8, (int)bc_thisfield.length);
    }

    public void testBcSuperFieldBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-40, -39, -38, -37, -33, -32, -31, -30, -1, 8, 8, 8, 8, 8, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)8, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_superfield = this.bcBands.getBcSuperField();
        BcBandsTest.assertEquals((int)8, (int)bc_superfield.length);
    }

    public void testBcThisMethodBand() throws IOException, Pack200Exception {
        byte[] bytes = new byte[]{-50, -49, -48, -43, -42, -41, -1, 8, 8, 8, 8, 8, 8};
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.bcBands.unpack((InputStream)in);
        BcBandsTest.assertEquals((int)6, (int)this.bcBands.getMethodByteCodePacked()[0][0].length);
        int[] bc_thismethod = this.bcBands.getBcThisMethod();
        BcBandsTest.assertEquals((int)6, (int)bc_thismethod.length);
    }

    public void testBcSuperMethodBand() throws IOException, Pack200Exception {
    }

    public void testBcInitRefRefBand() throws IOException, Pack200Exception {
    }

    public void testBcEscRefBands() throws IOException, Pack200Exception {
    }

    public void testBcEscBands() throws IOException, Pack200Exception {
    }

    public class MockSegment
    extends AbstractBandsTestCase.MockSegment {
        public CpBands cpBands;

        @Override
        protected AttrDefinitionBands getAttrDefinitionBands() {
            return new AbstractBandsTestCase.MockAttributeDefinitionBands(this);
        }

        protected CpBands getCpBands() {
            if (null == this.cpBands) {
                this.cpBands = new MockCpBands(this);
            }
            return this.cpBands;
        }

        protected ClassBands getClassBands() {
            return new MockClassBands(this);
        }

        public SegmentConstantPool getConstantPool() {
            return this.cpBands.getConstantPool();
        }
    }

    public class MockClassBands
    extends ClassBands {
        public MockClassBands(Segment segment) {
            super(segment);
        }

        public long[][] getMethodFlags() {
            long[][] flags = new long[BcBandsTest.this.numClasses][];
            for (int i = 0; i < flags.length; ++i) {
                flags[i] = new long[BcBandsTest.this.numMethods[i]];
            }
            return flags;
        }

        public int[] getCodeMaxStack() {
            int totalMethods = 0;
            for (int i = 0; i < BcBandsTest.this.numClasses; ++i) {
                totalMethods += BcBandsTest.this.numMethods[i];
            }
            return new int[totalMethods];
        }

        public int[] getCodeMaxNALocals() {
            int totalMethods = 0;
            for (int i = 0; i < BcBandsTest.this.numClasses; ++i) {
                totalMethods += BcBandsTest.this.numMethods[i];
            }
            return new int[totalMethods];
        }

        public boolean[] getCodeHasAttributes() {
            int totalMethods = 0;
            for (int i = 0; i < BcBandsTest.this.numClasses; ++i) {
                totalMethods += BcBandsTest.this.numMethods[i];
            }
            return new boolean[totalMethods];
        }

        public String[][] getMethodDescr() {
            String[][] descr = new String[BcBandsTest.this.numClasses][];
            for (int i = 0; i < descr.length; ++i) {
                descr[i] = new String[BcBandsTest.this.numMethods[i]];
                for (int j = 0; j < descr[i].length; ++j) {
                    descr[i][j] = "hello()";
                }
            }
            return descr;
        }

        public int[] getClassThisInts() {
            int[] thisClasses = new int[BcBandsTest.this.numClasses];
            for (int index = 0; index < BcBandsTest.this.numClasses; ++index) {
                thisClasses[index] = 0;
            }
            return thisClasses;
        }

        public int[] getClassSuperInts() {
            int[] superClasses = new int[BcBandsTest.this.numClasses];
            for (int index = 0; index < BcBandsTest.this.numClasses; ++index) {
                superClasses[index] = 0;
            }
            return superClasses;
        }

        public ArrayList[][] getMethodAttributes() {
            ArrayList[][] attributes = new ArrayList[BcBandsTest.this.numClasses][];
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i] = new ArrayList[BcBandsTest.this.numMethods[i]];
                for (int j = 0; j < attributes[i].length; ++j) {
                    attributes[i][j] = new ArrayList();
                }
            }
            return attributes;
        }

        public ArrayList getOrderedCodeAttributes() {
            int totalMethods = 0;
            for (int classIndex = 0; classIndex < BcBandsTest.this.numMethods.length; ++classIndex) {
                totalMethods += BcBandsTest.this.numMethods[classIndex];
            }
            ArrayList orderedAttributeList = new ArrayList();
            for (int classIndex = 0; classIndex < totalMethods; ++classIndex) {
                ArrayList currentAttributes = new ArrayList();
                orderedAttributeList.add(currentAttributes);
            }
            return orderedAttributeList;
        }
    }

    public class MockCpBands
    extends CpBands {
        private final CPUTF8 cpUTF8;
        private final CPClass cpClass;
        private final CPNameAndType descriptor;

        public MockCpBands(Segment segment) {
            super(segment);
            this.cpUTF8 = new CPUTF8("java/lang/String");
            this.cpClass = new CPClass(this.cpUTF8, -1);
            this.descriptor = new CPNameAndType(new CPUTF8("Hello"), new CPUTF8("(a, b, c)"), -1);
        }

        public CPString cpStringValue(int index) {
            return new CPString(this.cpUTF8, index);
        }

        public CPInteger cpIntegerValue(int index) {
            return new CPInteger(new Integer(21), index);
        }

        public CPClass cpClassValue(int index) {
            return this.cpClass;
        }

        public CPFloat cpFloatValue(int index) {
            return new CPFloat(new Float(2.5f), index);
        }

        public CPLong cpLongValue(int index) {
            return new CPLong(new Long(21L), index);
        }

        public CPDouble cpDoubleValue(int index) {
            return new CPDouble(new Double(2.5), index);
        }

        public CPFieldRef cpFieldValue(int index) {
            return new CPFieldRef(this.cpClass, this.descriptor, index);
        }

        public CPMethodRef cpMethodValue(int index) {
            return new CPMethodRef(this.cpClass, this.descriptor, index);
        }

        public CPInterfaceMethodRef cpIMethodValue(int index) {
            return new CPInterfaceMethodRef(this.cpClass, this.descriptor, index);
        }

        public String[] getCpClass() {
            return new String[]{"Hello"};
        }

        public String[] getCpFieldClass() {
            return new String[0];
        }

        public String[] getCpMethodClass() {
            return new String[0];
        }

        public String[] getCpIMethodClass() {
            return new String[0];
        }
    }
}

