/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.harmony.pack200.BHSDCodec;
import org.apache.commons.compress.harmony.pack200.Codec;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.ClassBands;
import org.apache.commons.compress.harmony.unpack200.CpBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.tests.AbstractBandsTestCase;

public class ClassBandsTest
extends AbstractBandsTestCase {
    private String[] cpClasses;
    private String[] cpDescriptor;
    private String[] cpUTF8;
    ClassBands classBands = new ClassBands((Segment)new MockSegment());

    public void testSimple() throws IOException, Pack200Exception {
        this.cpClasses = new String[]{"Class1", "Class2", "Class3", "Interface1", "Interface2"};
        this.cpDescriptor = new String[0];
        this.cpUTF8 = new String[0];
        byte[] classThis = Codec.DELTA5.encode(1, 0);
        byte[] classSuper = Codec.DELTA5.encode(2, 0);
        byte[] classInterfaceCount = Codec.DELTA5.encode(2, 0);
        byte[] classInterfaceRef1 = this.encodeBandInt(new int[]{3, 4}, Codec.DELTA5);
        byte[] classFieldCount = Codec.DELTA5.encode(0, 0);
        byte[] classMethodCount = Codec.DELTA5.encode(0, 0);
        byte[] classFlags = Codec.UNSIGNED5.encode(0, 0);
        byte[][] allArrays = new byte[][]{classThis, classSuper, classInterfaceCount, classInterfaceRef1, classFieldCount, classMethodCount, classFlags};
        int total = classThis.length + classSuper.length + classInterfaceCount.length + classInterfaceRef1.length + classFieldCount.length + classMethodCount.length + classFlags.length;
        byte[] bytes = new byte[total];
        int index = 0;
        for (int i = 0; i < allArrays.length; ++i) {
            for (int j = 0; j < allArrays[i].length; ++j) {
                bytes[index] = allArrays[i][j];
                ++index;
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.classBands.unpack((InputStream)in);
        ClassBandsTest.assertEquals((int)1, (int)this.classBands.getClassThisInts()[0]);
        ClassBandsTest.assertEquals((int)2, (int)this.classBands.getClassSuperInts()[0]);
        ClassBandsTest.assertEquals((int)1, (int)this.classBands.getClassInterfacesInts().length);
        ClassBandsTest.assertEquals((int)2, (int)this.classBands.getClassInterfacesInts()[0].length);
        ClassBandsTest.assertEquals((int)3, (int)this.classBands.getClassInterfacesInts()[0][0]);
        ClassBandsTest.assertEquals((int)4, (int)this.classBands.getClassInterfacesInts()[0][1]);
        this.cpClasses = null;
    }

    public void testWithMethods() throws Pack200Exception, IOException {
        this.cpClasses = new String[]{"Class1", "Class2", "Class3"};
        this.cpDescriptor = new String[]{"method1", "method2", "method3"};
        this.cpUTF8 = new String[0];
        byte[] classThis = Codec.DELTA5.encode(1, 0);
        byte[] classSuper = Codec.DELTA5.encode(2, 0);
        byte[] classInterfaceCount = Codec.DELTA5.encode(0, 0);
        byte[] classFieldCount = Codec.DELTA5.encode(0, 0);
        byte[] classMethodCount = Codec.DELTA5.encode(3, 0);
        byte[] methodDescr = this.encodeBandInt(new int[]{0, 1, 2}, Codec.MDELTA5);
        byte[] methodFlagsLo = this.encodeBandInt(new int[]{0, 0, 0}, Codec.UNSIGNED5);
        byte[] classFlags = Codec.UNSIGNED5.encode(0, 0);
        byte[][] allArrays = new byte[][]{classThis, classSuper, classInterfaceCount, classFieldCount, classMethodCount, methodDescr, methodFlagsLo, classFlags};
        int total = 0;
        for (int i = 0; i < allArrays.length; ++i) {
            total += allArrays[i].length;
        }
        byte[] bytes = new byte[total];
        int index = 0;
        for (int i = 0; i < allArrays.length; ++i) {
            for (int j = 0; j < allArrays[i].length; ++j) {
                bytes[index] = allArrays[i][j];
                ++index;
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        this.classBands.unpack((InputStream)in);
        ClassBandsTest.assertEquals((int)1, (int)this.classBands.getClassThisInts()[0]);
        ClassBandsTest.assertEquals((int)2, (int)this.classBands.getClassSuperInts()[0]);
        ClassBandsTest.assertEquals((int)1, (int)this.classBands.getMethodDescr().length);
        ClassBandsTest.assertEquals((int)3, (int)this.classBands.getMethodDescr()[0].length);
        ClassBandsTest.assertEquals((String)this.cpDescriptor[0], (String)this.classBands.getMethodDescr()[0][0]);
        ClassBandsTest.assertEquals((String)this.cpDescriptor[1], (String)this.classBands.getMethodDescr()[0][1]);
        ClassBandsTest.assertEquals((String)this.cpDescriptor[2], (String)this.classBands.getMethodDescr()[0][2]);
        this.cpClasses = null;
        this.cpDescriptor = null;
    }

    public byte[] encodeBandInt(int[] data, BHSDCodec codec) throws IOException, Pack200Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < data.length; ++i) {
            baos.write(codec.encode(data[i], i == 0 ? 0 : data[i - 1]));
        }
        return baos.toByteArray();
    }

    public class MockSegment
    extends AbstractBandsTestCase.MockSegment {
        protected CpBands getCpBands() {
            return new MockCpBands(this);
        }
    }

    public class MockCpBands
    extends CpBands {
        public MockCpBands(Segment segment) {
            super(segment);
        }

        public String[] getCpClass() {
            return ClassBandsTest.this.cpClasses;
        }

        public String[] getCpDescriptor() {
            return ClassBandsTest.this.cpDescriptor;
        }

        public String[] getCpUTF8() {
            return ClassBandsTest.this.cpUTF8;
        }

        public int[] getCpInt() {
            return new int[0];
        }

        public double[] getCpDouble() {
            return new double[0];
        }

        public long[] getCpLong() {
            return new long[0];
        }

        public float[] getCpFloat() {
            return new float[0];
        }

        public String[] getCpSignature() {
            return new String[0];
        }
    }
}

