/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.ChecksumCalculatingInputStream;
import org.junit.Assert;
import org.junit.Test;

public class ChecksumCalculatingInputStreamTest {
    @Test
    public void testSkipReturningZero() throws IOException {
        Adler32 adler32 = new Adler32();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY);
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);
        long skipResult = checksumCalculatingInputStream.skip(60L);
        Assert.assertEquals((long)0L, (long)skipResult);
        Assert.assertEquals((long)1L, (long)checksumCalculatingInputStream.getValue());
    }

    @Test
    public void testSkipReturningPositive() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);
        long skipResult = checksumCalculatingInputStream.skip(0L);
        Assert.assertEquals((long)1L, (long)skipResult);
        Assert.assertEquals((long)65537L, (long)checksumCalculatingInputStream.getValue());
    }

    @Test
    public void testReadTakingNoArguments() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)checksumCalculatingInputStream);
        int inputStreamReadResult = bufferedInputStream.read(byteArray, 0, 1);
        int checkSumCalculationReadResult = checksumCalculatingInputStream.read();
        Assert.assertNotEquals((long)checkSumCalculationReadResult, (long)inputStreamReadResult);
        Assert.assertEquals((long)-1L, (long)checkSumCalculationReadResult);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertEquals((long)393217L, (long)checksumCalculatingInputStream.getValue());
    }

    @Test
    public void testReadTakingByteArray() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[6];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream);
        int readResult = checksumCalculatingInputStream.read(byteArray);
        Assert.assertEquals((long)6L, (long)readResult);
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertEquals((long)393217L, (long)checksumCalculatingInputStream.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void testClassInstantiationWithParameterBeingNullThrowsNullPointerExceptionOne() {
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testClassInstantiationWithParameterBeingNullThrowsNullPointerExceptionTwo() {
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream(null, (InputStream)new ByteArrayInputStream(new byte[1]));
    }

    @Test(expected=NullPointerException.class)
    public void testClassInstantiationWithParameterBeingNullThrowsNullPointerExceptionThree() {
        ChecksumCalculatingInputStream checksumCalculatingInputStream = new ChecksumCalculatingInputStream((Checksum)new CRC32(), null);
    }
}

