/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.lang.reflect.Method;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@RunWith(value=PaxExam.class)
public class OsgiITest {
    private static final String EXPECTED_BUNDLE_NAME = "org.apache.commons.commons-compress";
    @Inject
    private BundleContext ctx;

    @Test
    public void canLoadBundle() {
        Assert.assertNotNull((String)"Expected to find bundle org.apache.commons.commons-compress", (Object)this.loadBundle());
    }

    @Configuration
    public Option[] config() {
        return new Option[]{CoreOptions.systemProperty((String)"pax.exam.osgi.unresolved.fail").value("true"), CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.useFallbackRepositories").value("false"), CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.repositories").value("https://repo.maven.apache.org/maven2"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.scr").version("2.0.14"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.configadmin").version("1.8.16"), CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"pax.exam.invoker").value("junit"), CoreOptions.bundle((String)"link:classpath:META-INF/links/org.ops4j.pax.tipi.junit.link"), CoreOptions.bundle((String)"link:classpath:META-INF/links/org.ops4j.pax.exam.invoker.junit.link"), CoreOptions.mavenBundle().groupId("org.apache.servicemix.bundles").artifactId("org.apache.servicemix.bundles.hamcrest").version("1.3_1")}), (Option)CoreOptions.bundle((String)"reference:file:target/classes/").start()};
    }

    private Bundle loadBundle() {
        for (Bundle b : this.ctx.getBundles()) {
            if (!EXPECTED_BUNDLE_NAME.equals(b.getSymbolicName())) continue;
            return b;
        }
        return null;
    }

    @Test
    public void properlyDetectsRunningInsideOsgiEnv() throws Exception {
        Class osgiUtils = this.loadBundle().loadClass("org.apache.commons.compress.utils.OsgiUtils");
        Assert.assertNotNull((String)"Can load OsgiUtils via bundle", (Object)osgiUtils);
        Method m = osgiUtils.getMethod("isRunningInOsgiEnvironment", new Class[0]);
        Assert.assertNotNull((String)"Can access isRunningInOsgiEnvironment method", (Object)m);
        Assert.assertTrue((String)"Compress detects OSGi environment", (boolean)((Boolean)m.invoke(null, new Object[0])));
    }
}

