/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public final class ArTestCase
extends AbstractTestCase {
    @Test
    public void testArArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);){
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
            Files.copy(file1.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
            Files.copy(file2.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
    }

    @Test
    public void testArDelete() throws Exception {
        ArArchiveEntry entry2;
        Throwable throwable;
        ArchiveInputStream ais2;
        Throwable throwable2;
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);){
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
            Files.copy(file1.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
            Files.copy(file2.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
        Assertions.assertEquals((long)(68L + file1.length() + file1.length() % 2L + 60L + file2.length() + file2.length() % 2L), (long)output.length());
        File output2 = new File(this.dir, "bla2.ar");
        int copied = 0;
        int deleted = 0;
        try (OutputStream os = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
             InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);){
            throwable2 = null;
            try (ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream("ar", os);){
                ais2 = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
                throwable = null;
                try {
                    while ((entry2 = (ArArchiveEntry)ais2.getNextEntry()) != null) {
                        if ("test1.xml".equals(entry2.getName())) {
                            aos.putArchiveEntry((ArchiveEntry)entry2);
                            IOUtils.copy((InputStream)ais2, (OutputStream)aos);
                            aos.closeArchiveEntry();
                            ++copied;
                            continue;
                        }
                        IOUtils.copy((InputStream)ais2, (OutputStream)new ByteArrayOutputStream());
                        ++deleted;
                    }
                }
                catch (Throwable entry2) {
                    throwable = entry2;
                    throw entry2;
                }
                finally {
                    if (ais2 != null) {
                        if (throwable != null) {
                            try {
                                ais2.close();
                            }
                            catch (Throwable entry2) {
                                throwable.addSuppressed(entry2);
                            }
                        } else {
                            ais2.close();
                        }
                    }
                }
            }
            catch (Throwable ais2) {
                throwable2 = ais2;
                throw ais2;
            }
        }
        Assertions.assertEquals((int)1, (int)copied);
        Assertions.assertEquals((int)1, (int)deleted);
        Assertions.assertEquals((long)(68L + file1.length() + file1.length() % 2L), (long)output2.length());
        long files = 0L;
        long sum = 0L;
        throwable2 = null;
        try (InputStream is = Files.newInputStream(output2.toPath(), new OpenOption[0]);){
            ais2 = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));
            throwable = null;
            try {
                while ((entry2 = (ArArchiveEntry)ais2.getNextEntry()) != null) {
                    IOUtils.copy((InputStream)ais2, (OutputStream)new ByteArrayOutputStream());
                    sum += entry2.getLength();
                    ++files;
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (ais2 != null) {
                    if (throwable != null) {
                        try {
                            ais2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ais2.close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable2 = throwable5;
            throw throwable5;
        }
        Assertions.assertEquals((long)1L, (long)files);
        Assertions.assertEquals((long)file1.length(), (long)sum);
    }

    @Test
    public void testArUnarchive() throws Exception {
        File output = new File(this.dir, "bla.ar");
        File file1 = ArTestCase.getFile("test1.xml");
        File file2 = ArTestCase.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);){
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
            Files.copy(file1.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
            Files.copy(file2.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
        try (InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);){
            var5_7 = null;
            try (ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));){
                ArArchiveEntry entry = (ArArchiveEntry)in.getNextEntry();
                File target = new File(this.dir, entry.getName());
                Files.copy((InputStream)in, target.toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        InputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry in = new ArArchiveEntry("foo", tmp[1].length(), 0, 0, 0, tmp[1].lastModified() / 1000L);
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assertions.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        InputStream fis = null;
        File directory = tmp[0];
        File file = tmp[1];
        try {
            archive = File.createTempFile("test.", ".ar", directory);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry in = new ArArchiveEntry(file, "foo");
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)file.length()];
            fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)file.length(), (long)out.getSize());
            Assertions.assertEquals((long)(file.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(file);
            ArTestCase.rmdir(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromPath() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        InputStream fis = null;
        File directory = tmp[0];
        File file = tmp[1];
        try {
            archive = File.createTempFile("test.", ".ar", directory);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry in = new ArArchiveEntry(file.toPath(), "foo", new LinkOption[0]);
            aos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)file.length()];
            fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                aos.write(b);
            }
            fis.close();
            fis = null;
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)file.length(), (long)out.getSize());
            Assertions.assertEquals((long)(file.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            ArTestCase.tryHardToDelete(file);
            ArTestCase.rmdir(directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled
    @Test
    public void XtestDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            ArArchiveEntry in = new ArArchiveEntry(tmp[0], "foo");
            aos.putArchiveEntry((ArchiveEntry)in);
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo/", (Object)out.getName());
            Assertions.assertEquals((long)0L, (long)out.getSize());
            Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled
    @Test
    public void XtestExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        ArArchiveOutputStream aos = null;
        ArArchiveInputStream ais = null;
        try {
            archive = File.createTempFile("test.", ".ar", tmp[0]);
            archive.deleteOnExit();
            aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            ArArchiveEntry in = new ArArchiveEntry("foo", 0L, 0, 0, 0, tmp[1].lastModified() / 1000L);
            aos.putArchiveEntry((ArchiveEntry)in);
            aos.closeArchiveEntry();
            aos.close();
            aos = null;
            ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            ArArchiveEntry out = ais.getNextArEntry();
            ais.close();
            ais = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo/", (Object)out.getName());
            Assertions.assertEquals((long)0L, (long)out.getSize());
            Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (ais != null) {
                ais.close();
            }
            if (aos != null) {
                aos.close();
            }
            ArTestCase.tryHardToDelete(archive);
            ArTestCase.tryHardToDelete(tmp[1]);
            ArTestCase.rmdir(tmp[0]);
        }
    }
}

