/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArchiveOutputStreamTest
extends AbstractTestCase {
    private ArchiveOutputStream createArchiveWithDummyEntry(String archiveType, OutputStream out1, File dummy) throws Exception {
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream(archiveType, out1);
        aos1.putArchiveEntry(aos1.createArchiveEntry(dummy, "dummy"));
        Files.copy(dummy.toPath(), (OutputStream)aos1);
        return aos1;
    }

    private void doCallSequence(String archiveType) throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        File dummy = ArchiveOutputStreamTest.getFile("test1.xml");
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream(archiveType, (OutputStream)out1);
        aos1.putArchiveEntry(aos1.createArchiveEntry(dummy, "dummy"));
        Files.copy(dummy.toPath(), (OutputStream)aos1);
        aos1.closeArchiveEntry();
        aos1.close();
        ArchiveOutputStream aos2 = this.factory.createArchiveOutputStream(archiveType, (OutputStream)out1);
        Assertions.assertThrows(IOException.class, () -> ((ArchiveOutputStream)aos2).closeArchiveEntry(), (String)"Should have raised IOException - closeArchiveEntry() called before putArchiveEntry()");
        aos2.putArchiveEntry(aos2.createArchiveEntry(dummy, "dummy"));
        Files.copy(dummy.toPath(), (OutputStream)aos2);
        Assertions.assertThrows(IOException.class, () -> ((ArchiveOutputStream)aos2).finish(), (String)"Should have raised IOException - finish() called before closeArchiveEntry()");
        Assertions.assertThrows(IOException.class, () -> aos2.close(), (String)"Should have raised IOException - close() called before closeArchiveEntry()");
        ArchiveOutputStream aos3 = this.createArchiveWithDummyEntry(archiveType, out1, dummy);
        aos3.closeArchiveEntry();
        Assertions.assertThrows(IOException.class, () -> ((ArchiveOutputStream)aos3).closeArchiveEntry(), (String)"Should have raised IOException - closeArchiveEntry() called with no open entry");
        ArchiveOutputStream aos4 = this.createArchiveWithDummyEntry(archiveType, out1, dummy);
        aos4.closeArchiveEntry();
        aos4.finish();
        aos4.close();
        Assertions.assertThrows(IOException.class, () -> ((ArchiveOutputStream)aos4).finish(), (String)"Should have raised IOException - finish() called after close()");
    }

    @Test
    public void testCallSequenceAr() throws Exception {
        this.doCallSequence("Ar");
    }

    @Test
    public void testCallSequenceCpio() throws Exception {
        this.doCallSequence("Cpio");
    }

    @Test
    public void testCallSequenceJar() throws Exception {
        this.doCallSequence("Jar");
    }

    @Test
    public void testCallSequenceTar() throws Exception {
        this.doCallSequence("Tar");
    }

    @Test
    public void testCallSequenceZip() throws Exception {
        this.doCallSequence("Zip");
    }

    @Test
    public void testFinish() throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("zip", (OutputStream)out1);
        aos1.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("dummy"));
        Assertions.assertThrows(IOException.class, () -> aos1.finish(), (String)"After putArchive should follow closeArchive");
        ArchiveOutputStream aos2 = this.factory.createArchiveOutputStream("jar", (OutputStream)out1);
        aos2.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("dummy"));
        Assertions.assertThrows(IOException.class, () -> aos2.finish(), (String)"After putArchive should follow closeArchive");
        ArchiveOutputStream aos3 = this.factory.createArchiveOutputStream("ar", (OutputStream)out1);
        aos3.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("dummy", 100L));
        Assertions.assertThrows(IOException.class, () -> aos3.finish(), (String)"After putArchive should follow closeArchive");
        ArchiveOutputStream aos4 = this.factory.createArchiveOutputStream("cpio", (OutputStream)out1);
        aos4.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("dummy"));
        Assertions.assertThrows(IOException.class, () -> aos4.finish(), (String)"After putArchive should follow closeArchive");
        ArchiveOutputStream aos5 = this.factory.createArchiveOutputStream("tar", (OutputStream)out1);
        aos5.putArchiveEntry((ArchiveEntry)new TarArchiveEntry("dummy"));
        Assertions.assertThrows(IOException.class, () -> aos5.finish(), (String)"After putArchive should follow closeArchive");
    }

    @Test
    public void testOptionalFinish() throws Exception {
        ArchiveOutputStream finishTest;
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        try (ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("zip", (OutputStream)out1);){
            aos1.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("dummy"));
            aos1.closeArchiveEntry();
        }
        try (ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream("jar", (OutputStream)out1);){
            finishTest = aos1;
            aos1.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("dummy"));
            aos1.closeArchiveEntry();
        }
        Assertions.assertThrows(IOException.class, () -> finishTest.finish(), (String)"finish() cannot follow close()");
        finishTest.close();
    }
}

