/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class CpioTestCase
extends AbstractTestCase {
    @Test
    public void testCpioArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.cpio");
        File file1 = CpioTestCase.getFile("test1.xml");
        File file2 = CpioTestCase.getFile("test2.xml");
        OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
        ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("cpio", out);
        os.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("test1.xml", file1.length()));
        Files.copy(file1.toPath(), (OutputStream)os);
        os.closeArchiveEntry();
        os.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry("test2.xml", file2.length()));
        Files.copy(file2.toPath(), (OutputStream)os);
        os.closeArchiveEntry();
        os.close();
        out.close();
    }

    @Test
    public void testCpioUnarchive() throws Exception {
        File output = new File(this.dir, "bla.cpio");
        File file1 = CpioTestCase.getFile("test1.xml");
        File file2 = CpioTestCase.getFile("test2.xml");
        long file1Length = file1.length();
        long file2Length = file2.length();
        OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
        ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("cpio", out);
        CpioArchiveEntry entry = new CpioArchiveEntry("test1.xml", file1Length);
        entry.setMode(32768L);
        os.putArchiveEntry((ArchiveEntry)entry);
        Files.copy(file1.toPath(), (OutputStream)os);
        os.closeArchiveEntry();
        entry = new CpioArchiveEntry("test2.xml", file2Length);
        entry.setMode(32768L);
        os.putArchiveEntry((ArchiveEntry)entry);
        Files.copy(file2.toPath(), (OutputStream)os);
        os.closeArchiveEntry();
        os.finish();
        os.close();
        out.close();
        InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
        ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("cpio", is);
        HashMap<String, File> result = new HashMap<String, File>();
        ArchiveEntry entry2 = null;
        while ((entry2 = in.getNextEntry()) != null) {
            File cpioget = new File(this.dir, entry2.getName());
            Files.copy((InputStream)in, cpioget.toPath(), new CopyOption[0]);
            result.put(entry2.getName(), cpioget);
        }
        in.close();
        is.close();
        File t = (File)result.get("test1.xml");
        Assertions.assertTrue((boolean)t.exists(), (String)("Expected " + t.getAbsolutePath() + " to exist"));
        Assertions.assertEquals((long)file1Length, (long)t.length(), (String)("length of " + t.getAbsolutePath()));
        t = (File)result.get("test2.xml");
        Assertions.assertTrue((boolean)t.exists(), (String)("Expected " + t.getAbsolutePath() + " to exist"));
        Assertions.assertEquals((long)file2Length, (long)t.length(), (String)("length of " + t.getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            CpioArchiveEntry in = new CpioArchiveEntry(tmp[0], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)0L, (long)out.getSize());
            Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitDirectoryEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            long beforeArchiveWrite = tmp[0].lastModified();
            CpioArchiveEntry in = new CpioArchiveEntry("foo/");
            in.setTime(beforeArchiveWrite / 1000L);
            in.setMode(16384L);
            tos.putArchiveEntry((ArchiveEntry)in);
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo/", (Object)out.getName());
            Assertions.assertEquals((long)0L, (long)out.getSize());
            Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertTrue((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitFileEntry() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        InputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            CpioArchiveEntry in = new CpioArchiveEntry("foo");
            in.setTime(tmp[1].lastModified() / 1000L);
            in.setSize(tmp[1].length());
            in.setMode(32768L);
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assertions.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEntryFromFile() throws Exception {
        File[] tmp = this.createTempDirAndFile();
        File archive = null;
        CpioArchiveOutputStream tos = null;
        CpioArchiveInputStream tis = null;
        InputStream fis = null;
        try {
            archive = File.createTempFile("test.", ".cpio", tmp[0]);
            archive.deleteOnExit();
            tos = new CpioArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));
            CpioArchiveEntry in = new CpioArchiveEntry(tmp[1], "foo");
            tos.putArchiveEntry((ArchiveEntry)in);
            byte[] b = new byte[(int)tmp[1].length()];
            fis = Files.newInputStream(tmp[1].toPath(), new OpenOption[0]);
            while (fis.read(b) > 0) {
                tos.write(b);
            }
            fis.close();
            fis = null;
            tos.closeArchiveEntry();
            tos.close();
            tos = null;
            tis = new CpioArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));
            CpioArchiveEntry out = tis.getNextCPIOEntry();
            tis.close();
            tis = null;
            Assertions.assertNotNull((Object)out);
            Assertions.assertEquals((Object)"foo", (Object)out.getName());
            Assertions.assertEquals((long)tmp[1].length(), (long)out.getSize());
            Assertions.assertEquals((long)(tmp[1].lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
            Assertions.assertFalse((boolean)out.isDirectory());
        }
        finally {
            if (tis != null) {
                tis.close();
            }
            if (tos != null) {
                tos.close();
            }
            CpioTestCase.tryHardToDelete(archive);
            if (fis != null) {
                fis.close();
            }
            CpioTestCase.tryHardToDelete(tmp[1]);
            CpioTestCase.rmdir(tmp[0]);
        }
    }
}

