/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class DumpTestCase
extends AbstractTestCase {
    private void archiveDetection(File f) throws Exception {
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            Assertions.assertEquals(DumpArchiveInputStream.class, ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)new BufferedInputStream(is)).getClass());
        }
    }

    private void checkDumpArchive(File f) throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("");
        expected.add("lost+found/");
        expected.add("test1.xml");
        expected.add("test2.xml");
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            this.checkArchiveContent((ArchiveInputStream)new DumpArchiveInputStream(is), expected);
        }
    }

    @Test
    public void testArchiveDetection() throws Exception {
        this.archiveDetection(DumpTestCase.getFile("bla.dump"));
    }

    @Test
    public void testCheckArchive() throws Exception {
        this.checkDumpArchive(DumpTestCase.getFile("bla.dump"));
    }

    @Test
    public void testCheckCompressedArchive() throws Exception {
        this.checkDumpArchive(DumpTestCase.getFile("bla.z.dump"));
    }

    @Test
    public void testCompressedArchiveDetection() throws Exception {
        this.archiveDetection(DumpTestCase.getFile("bla.z.dump"));
    }

    @Test
    public void testCompressedDumpUnarchiveAll() throws Exception {
        this.unarchiveAll(DumpTestCase.getFile("bla.z.dump"));
    }

    @Test
    public void testDumpUnarchiveAll() throws Exception {
        this.unarchiveAll(DumpTestCase.getFile("bla.dump"));
    }

    private void unarchiveAll(File input) throws Exception {
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("dump", is);){
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = new File(this.dir, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                entry = in.getNextEntry();
            }
        }
    }
}

