/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.junit.jupiter.api.Test;

public final class JarTestCase
extends AbstractTestCase {
    @Test
    public void testJarArchiveCreation() throws Exception {
        File output = new File(this.dir, "bla.jar");
        File file1 = JarTestCase.getFile("test1.xml");
        File file2 = JarTestCase.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("jar", out);){
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test1.xml"));
            Files.copy(file1.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("testdata/test2.xml"));
            Files.copy(file2.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
    }

    @Test
    public void testJarUnarchive() throws Exception {
        File input = JarTestCase.getFile("bla.jar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            ZipArchiveEntry entry = (ZipArchiveEntry)in.getNextEntry();
            File o = new File(this.dir, entry.getName());
            o.getParentFile().mkdirs();
            Files.copy((InputStream)in, o.toPath(), new CopyOption[0]);
            entry = (ZipArchiveEntry)in.getNextEntry();
            o = new File(this.dir, entry.getName());
            o.getParentFile().mkdirs();
            Files.copy((InputStream)in, o.toPath(), new CopyOption[0]);
            entry = (ZipArchiveEntry)in.getNextEntry();
            o = new File(this.dir, entry.getName());
            o.getParentFile().mkdirs();
            Files.copy((InputStream)in, o.toPath(), new CopyOption[0]);
        }
    }

    @Test
    public void testJarUnarchiveAll() throws Exception {
        File input = JarTestCase.getFile("bla.jar");
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("jar", is);){
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = new File(this.dir, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                entry = in.getNextEntry();
            }
        }
    }
}

