/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CpioArchiveOutputStreamTest
extends AbstractTestCase {
    @Test
    public void testWriteOldBinary() throws Exception {
        File f = CpioArchiveOutputStreamTest.getFile("test1.xml");
        File output = new File(this.dir, "test.cpio");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             CpioArchiveOutputStream os = new CpioArchiveOutputStream(out, 8);){
            os.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry(8, f, "test1.xml"));
            Files.copy(f.toPath(), (OutputStream)os);
            os.closeArchiveEntry();
        }
        var4_4 = null;
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(Files.newInputStream(output.toPath(), new OpenOption[0]));){
            CpioArchiveEntry e = in.getNextCPIOEntry();
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertNull((Object)in.getNextEntry());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }
}

